/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.util.Location;

@Mod.EventBusSubscriber(modid="pylons")
public class ChunkManager {
    private static final Map<UUID, Location> loaded = new ConcurrentHashMap<UUID, Location>();
    private static final Map<UUID, Location> unloaded = new ConcurrentHashMap<UUID, Location>();

    private ChunkManager() {
    }

    @SubscribeEvent
    public static void beforeServerStopped(FMLServerStoppedEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void afterServerStarted(FMLServerStartedEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void onLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        UUID uuid = event.getPlayer().func_110124_au();
        if (uuid != null && unloaded.containsKey(uuid)) {
            ServerWorld level;
            Location location = unloaded.get(uuid);
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (location != null && server != null && (level = server.func_71218_a(location.level)) != null) {
                ChunkManager.loadChunk(uuid, level, location.blockPos);
            }
        }
    }

    @SubscribeEvent
    public static void onLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getPlayer().func_110124_au();
        if (uuid != null && loaded.containsKey(uuid)) {
            ServerWorld level;
            Location location = loaded.get(uuid);
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (location != null && server != null && (level = server.func_71218_a(location.level)) != null) {
                ChunkManager.unloadChunk(uuid, level, location.blockPos);
            }
        }
    }

    public static void loadChunk(UUID owner, ServerWorld level, BlockPos pos) {
        if (Boolean.TRUE.equals(ConfigManager.SERVER.infusionChunkloads.get()) && !loaded.containsKey(owner)) {
            Location location = Location.of(level, pos);
            unloaded.remove(owner, location);
            loaded.put(owner, location);
            ForgeChunkManager.forceChunk((ServerWorld)level, (String)"pylons", (BlockPos)pos, (int)location.chunkX, (int)location.chunkZ, (boolean)true, (boolean)false);
        }
    }

    public static void unloadChunk(UUID owner, ServerWorld level, BlockPos pos) {
        Location location = Location.of(level, pos);
        loaded.remove(owner, location);
        unloaded.put(owner, location);
        ForgeChunkManager.forceChunk((ServerWorld)level, (String)"pylons", (BlockPos)pos, (int)location.chunkX, (int)location.chunkZ, (boolean)false, (boolean)false);
    }

    public static void validateTickets(ServerWorld level, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
    }
}

