/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.tile.AbstractPylonTile;

public class HarvesterPylonTile
extends AbstractPylonTile {
    Status workStatus = Status.NONE;

    public HarvesterPylonTile() {
        super((TileEntityType)ModRegistry.HARVESTER_PYLON_TILE.get());
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{3, 5, 7, 9};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.func_77973_b() instanceof HoeItem;
    }

    private boolean requiresTool() {
        return Boolean.TRUE.equals(ConfigManager.SERVER.harvesterRequiresTool.get());
    }

    private int getWorkDelay() {
        return (Integer)ConfigManager.SERVER.harvesterWorkDelay.get();
    }

    @Override
    public void updateContainer(PacketBuffer packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.func_179249_a((Enum)this.workStatus);
    }

    public void func_73660_a() {
        if (this.field_145850_b instanceof ServerWorld && this.canTick(this.getWorkDelay())) {
            ServerWorld serverLevel = (ServerWorld)this.field_145850_b;
            BlockPos above = this.func_174877_v().func_177984_a();
            TileEntity target = this.field_145850_b.func_175625_s(above);
            if (target == null) {
                this.workStatus = Status.MISSING_INVENTORY;
                return;
            }
            IItemHandler itemHandler = target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).resolve().orElse(null);
            if (itemHandler == null) {
                this.workStatus = Status.MISSING_INVENTORY;
                return;
            }
            int hoeSlot = -1;
            if (this.requiresTool()) {
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    if (!this.isItemValid(this.itemStackHandler.getStackInSlot(i))) continue;
                    hoeSlot = i;
                    break;
                }
                if (hoeSlot == -1) {
                    this.workStatus = Status.MISSING_TOOL;
                    return;
                }
            }
            int radius = (this.range.get() - 1) / 2;
            int minX = above.func_177958_n() - radius;
            int minZ = above.func_177952_p() - radius;
            int maxX = above.func_177958_n() + radius;
            int maxZ = above.func_177952_p() + radius;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int maxAge;
                    BlockState blockState;
                    BlockPos workPos = new BlockPos(x, above.func_177956_o(), z);
                    if (!this.field_145850_b.func_195588_v(workPos) || !((blockState = this.field_145850_b.func_180495_p(workPos)).func_177230_c() instanceof CropsBlock)) continue;
                    CropsBlock crop = (CropsBlock)blockState.func_177230_c();
                    IntegerProperty ageProperty = crop.func_185524_e();
                    int currentAge = (Integer)blockState.func_177229_b((Property)ageProperty);
                    int minAge = (Integer)Collections.min(ageProperty.func_177700_c());
                    if (minAge == (maxAge = ((Integer)Collections.max(ageProperty.func_177700_c())).intValue()) || currentAge < maxAge) continue;
                    if (this.requiresTool()) {
                        if (hoeSlot == -1) {
                            this.workStatus = Status.MISSING_TOOL;
                            return;
                        }
                        ItemStack replace = this.itemStackHandler.getStackInSlot(hoeSlot).func_77946_l();
                        if (replace.func_96631_a(1, this.field_145850_b.func_201674_k(), null)) {
                            replace.func_190918_g(1);
                        }
                        this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                    }
                    ItemStack seedStack = crop.func_185473_a((IBlockReader)this.field_145850_b, workPos, blockState);
                    List drops = Block.func_220070_a((BlockState)blockState, (ServerWorld)serverLevel, (BlockPos)workPos, null);
                    BlockState modified = (BlockState)blockState.func_206870_a((Property)ageProperty, (Comparable)Integer.valueOf(minAge));
                    boolean updated = this.field_145850_b.func_175656_a(workPos, modified);
                    if (!updated) {
                        this.workStatus = Status.UPDATE_ERROR;
                        Pylons.LOGGER.error("Failed to reset crop age for position: {}", (Object)workPos);
                        return;
                    }
                    for (ItemStack drop : drops) {
                        boolean result;
                        if (!seedStack.func_190926_b() && drop.func_77973_b() == seedStack.func_77973_b()) {
                            drop.func_190918_g(1);
                        }
                        if (drop.func_190926_b() || (result = this.insertItemOrDiscard(itemHandler, drop))) continue;
                        this.workStatus = Status.INVENTORY_FULL;
                        return;
                    }
                }
            }
            this.workStatus = Status.WORKING;
        }
    }

    private boolean insertItemOrDiscard(IItemHandler itemHandler, ItemStack itemStack) {
        ItemStack progress = itemStack;
        for (int slot = 0; slot < itemHandler.getSlots() && !(progress = itemHandler.insertItem(slot, progress, false)).func_190926_b(); ++slot) {
        }
        return progress.func_190926_b();
    }

    public static enum Status {
        NONE,
        WORKING,
        MISSING_TOOL,
        MISSING_INVENTORY,
        INVENTORY_FULL,
        UPDATE_ERROR;

    }
}

