/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.permutated.pylons.util.ChunkManager;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPylonTile
extends TileEntity
implements ITickableTileEntity {
    public static final int SLOTS = 9;
    protected final ItemStackHandler itemStackHandler = new PylonItemStackHandler(9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractPylonTile.this.isItemValid(stack);
        }
    };
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemStackHandler);
    protected UUID owner = null;
    protected String ownerName = null;
    private long lastTicked = 0L;
    int offset = 0;
    protected boolean shouldWork = true;
    protected final Range range = new Range(this.getRange());

    protected AbstractPylonTile(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    protected abstract boolean isItemValid(ItemStack var1);

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropItems() {
        AbstractPylonTile.dropItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.itemStackHandler);
    }

    public void removeChunkloads() {
        if (this.owner != null && this.field_145850_b instanceof ServerWorld) {
            ChunkManager.unloadChunk(this.owner, (ServerWorld)this.field_145850_b, this.func_174877_v());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handler.invalidate();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean canAccess(PlayerEntity player) {
        return Objects.equals(player.func_110124_au(), this.owner) || this.owner == null || player.func_211513_k(2);
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.field_145850_b != null ? this.field_145850_b.func_82737_E() : 0L;
        if (this.offset(gameTime) % (long)every == 0L && gameTime != this.lastTicked && this.shouldWork()) {
            this.lastTicked = gameTime;
            return true;
        }
        return false;
    }

    protected long offset(long gameTime) {
        if (this.offset == 0) {
            this.offset += ThreadLocalRandom.current().nextInt(0, 20);
        }
        return gameTime + (long)this.offset;
    }

    protected static void dropItems(@Nullable World world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0 || world == null) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    public String getOwnerName() {
        String lastKnown = this.owner == null ? null : UsernameCache.getLastKnownUsername((UUID)this.owner);
        return StringUtils.defaultString((String)lastKnown, (String)"unknown");
    }

    public void updateContainer(PacketBuffer packetBuffer) {
        String lastKnown = UsernameCache.getLastKnownUsername((UUID)this.owner);
        String username = StringUtils.defaultString((String)lastKnown, (String)"unknown");
        packetBuffer.func_179255_a(this.field_174879_c);
        packetBuffer.writeInt(username.length());
        packetBuffer.func_180714_a(username);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.itemStackHandler.serializeNBT());
        tag.func_218657_a("range", (INBT)this.range.serializeNBT());
        this.writeFields(tag);
        return super.func_189515_b(tag);
    }

    private void writeFields(CompoundNBT tag) {
        tag.func_74757_a("enabled", this.shouldWork);
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.itemStackHandler.deserializeNBT(tag.func_74775_l("inv"));
        this.range.deserializeNBT(tag.func_74775_l("range"));
        this.readFields(tag);
        super.func_230337_a_(state, tag);
    }

    private void readFields(@Nullable CompoundNBT tag) {
        if (tag != null && tag.func_74764_b("enabled")) {
            this.shouldWork = tag.func_74767_n("enabled");
        }
        if (tag != null && tag.func_186855_b("owner")) {
            this.owner = tag.func_186857_a("owner");
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("range", (INBT)this.range.serializeNBT());
        this.writeFields(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag != null) {
            this.range.deserializeNBT(tag.func_74775_l("range"));
        }
        this.readFields(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public boolean shouldWork() {
        return this.shouldWork;
    }

    public void handleWorkPacket() {
        if (this.field_145850_b != null) {
            this.shouldWork = !this.shouldWork;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    protected byte[] getRange() {
        return new byte[]{1};
    }

    public int getSelectedRange() {
        return this.range.get();
    }

    public void handleRangePacket() {
        if (this.getRange().length > 1 && this.field_145850_b != null) {
            this.range.next();
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public class PylonItemStackHandler
    extends ItemStackHandler {
        public PylonItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            AbstractPylonTile.this.func_70296_d();
        }
    }
}

