/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.tile.AbstractPylonTile;

public class PacketButtonClicked {
    private final ButtonType buttonType;
    private final BlockPos blockPos;

    public PacketButtonClicked(ButtonType buttonType, BlockPos blockPos) {
        this.buttonType = buttonType;
        this.blockPos = blockPos;
    }

    public PacketButtonClicked(PacketBuffer buffer) {
        this.buttonType = (ButtonType)buffer.func_179257_a(ButtonType.class);
        this.blockPos = buffer.func_179259_c();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.buttonType);
        buffer.func_179255_a(this.blockPos);
    }

    public static void handle(PacketButtonClicked event, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity be;
            Optional<ServerPlayerEntity> player = Optional.ofNullable(((NetworkEvent.Context)ctx.get()).getSender());
            Optional<World> world = player.map(Entity::func_130014_f_);
            if (player.isPresent() && world.get() instanceof ServerWorld && world.get().func_195588_v(event.blockPos) && (be = world.get().func_175625_s(event.blockPos)) instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)be;
                if (ButtonType.RANGE.equals((Object)event.buttonType)) {
                    pylonTile.handleRangePacket();
                } else if (ButtonType.WORK.equals((Object)event.buttonType)) {
                    pylonTile.handleWorkPacket();
                } else {
                    Pylons.LOGGER.error("PacketButtonClicked called with invalid button type!");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum ButtonType {
        RANGE,
        WORK;

    }
}

