/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.LogicalSide;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.util.TranslationKey;

public class PlayerFilterCard
extends Item {
    public PlayerFilterCard() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModRegistry.CREATIVE_TAB).setNoRepair());
    }

    public static void onPlayerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() instanceof PlayerFilterCard && event.getTarget() instanceof PlayerEntity) {
            if (event.getSide() == LogicalSide.SERVER) {
                CompoundNBT tag = itemStack.func_190925_c("pylons");
                tag.func_186854_a("uuid", event.getTarget().func_110124_au());
                tag.func_74778_a("name", PlayerFilterCard.getProfileName(event.getTarget()));
                event.setCancellationResult(ActionResultType.SUCCESS);
            } else {
                event.setCancellationResult(ActionResultType.CONSUME);
            }
            event.setCanceled(true);
        }
    }

    protected static String getProfileName(Entity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return player.func_146103_bH().getName();
        }
        return "unknown";
    }

    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("pylons");
        return tag != null && tag.func_186855_b("uuid");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_179543_a("pylons");
        if (tag != null) {
            String username = tag.func_74779_i("name");
            tooltip.add((ITextComponent)this.translate("player", username).func_240699_a_(TextFormatting.BLUE));
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)this.translate("insert1"));
            tooltip.add((ITextComponent)this.translate("insert2"));
        } else {
            tooltip.add((ITextComponent)this.translate("no_player"));
        }
    }

    protected IFormattableTextComponent translate(String key) {
        return new TranslationTextComponent(TranslationKey.tooltip(key)).func_240699_a_(TextFormatting.GRAY);
    }

    protected TranslationTextComponent translate(String key, Object ... values) {
        return new TranslationTextComponent(TranslationKey.tooltip(key), values);
    }
}

