/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.permutated.pylons.network.NetworkDispatcher;
import net.permutated.pylons.network.PacketButtonClicked;
import net.permutated.pylons.tile.AbstractPylonTile;

public abstract class AbstractPylonContainer
extends Container {
    @Nullable
    private final AbstractPylonTile tileEntity;
    protected final String ownerName;
    protected final BlockPos blockPos;

    protected AbstractPylonContainer(@Nullable ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        super(containerType, windowId);
        this.blockPos = packetBuffer.func_179259_c();
        World world = playerInventory.field_70458_d.func_130014_f_();
        this.tileEntity = (AbstractPylonTile)world.func_175625_s(this.blockPos);
        InvWrapper wrappedInventory = new InvWrapper((IInventory)playerInventory);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < 9; ++slot) {
                    this.func_75146_a((Slot)new SlotItemHandler(handler, slot, 8 + slot * 18, 54));
                }
            });
        }
        int nameLength = packetBuffer.readInt();
        this.ownerName = packetBuffer.func_150789_c(nameLength);
        this.registerPlayerSlots((IItemHandler)wrappedInventory);
    }

    protected abstract RegistryObject<Block> getBlock();

    protected int getInventorySize() {
        return 9;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public ITextComponent getWorkComponent() {
        boolean shouldWork = this.tileEntity != null && this.tileEntity.shouldWork();
        return new StringTextComponent(shouldWork ? "On" : "Off");
    }

    public void sendWorkPacket(Button button) {
        NetworkDispatcher.INSTANCE.sendToServer((Object)new PacketButtonClicked(PacketButtonClicked.ButtonType.WORK, this.blockPos));
    }

    public boolean shouldRenderRange() {
        return false;
    }

    public ITextComponent getRangeComponent() {
        int range = this.tileEntity != null ? this.tileEntity.getSelectedRange() : 0;
        return new StringTextComponent(String.format("%dx%d", range, range));
    }

    public void sendRangePacket(Button button) {
        NetworkDispatcher.INSTANCE.sendToServer((Object)new PacketButtonClicked(PacketButtonClicked.ButtonType.RANGE, this.blockPos));
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        World world;
        if (this.tileEntity != null && (world = this.tileEntity.func_145831_w()) != null) {
            IWorldPosCallable callable = IWorldPosCallable.func_221488_a((World)world, (BlockPos)this.tileEntity.func_174877_v());
            return AbstractPylonContainer.func_216963_a((IWorldPosCallable)callable, (PlayerEntity)playerEntity, (Block)((Block)this.getBlock().get()));
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int inventorySize = this.getInventorySize();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index < inventorySize ? !this.func_75135_a(stack, inventorySize, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, inventorySize, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void registerPlayerSlots(IItemHandler wrappedInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler(wrappedInventory, j + i * 9 + 9, 8 + j * 18, 90 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(wrappedInventory, i, 8 + i * 18, 148));
        }
    }
}

