/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.option;

import fuzs.puzzleslib.config.option.ConfigOption;
import java.util.function.BiFunction;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class EnumOption<T extends Enum<T>>
extends ConfigOption<T> {
    private final Class<?> clazz;
    private final T[] acceptableValues;

    EnumOption(ForgeConfigSpec.ConfigValue<T> value, ModConfig.Type type, EnumOptionBuilder<T> builder) {
        super(value, type, builder);
        this.clazz = ((EnumOptionBuilder)builder).clazz;
        this.acceptableValues = ((EnumOptionBuilder)builder).acceptableValues;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public T[] getAcceptableValues() {
        return this.acceptableValues;
    }

    public static class EnumOptionBuilder<T extends Enum<T>>
    extends ConfigOption.ConfigOptionBuilder<T> {
        private final Class<?> clazz;
        private T[] acceptableValues;

        EnumOptionBuilder(String name, T defaultValue) {
            super(name, defaultValue);
            this.clazz = ((Enum)defaultValue).getDeclaringClass();
            this.acceptableValues = (Enum[])this.clazz.getEnumConstants();
        }

        @SafeVarargs
        public final EnumOptionBuilder<T> acceptable(T ... acceptableValues) {
            this.acceptableValues = acceptableValues;
            return this;
        }

        @Override
        BiFunction<ForgeConfigSpec.ConfigValue<T>, ModConfig.Type, ConfigOption<T>> getFactory() {
            return (value, type) -> new EnumOption(value, (ModConfig.Type)type, this);
        }

        @Override
        ForgeConfigSpec.ConfigValue<T> getConfigValue(ForgeConfigSpec.Builder builder) {
            return builder.defineEnum(this.name, (Enum)this.defaultValue, this.acceptableValues);
        }
    }
}

