/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.element;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.option.ConfigOption;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.element.EventListener;
import fuzs.puzzleslib.element.IConfigurableElement;
import fuzs.puzzleslib.element.IRegistryElement;
import fuzs.puzzleslib.element.side.IClientElement;
import fuzs.puzzleslib.element.side.ICommonElement;
import fuzs.puzzleslib.element.side.IServerElement;
import fuzs.puzzleslib.element.side.ISidedElement;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractElement
extends EventListener
implements IConfigurableElement,
IRegistryElement<AbstractElement> {
    private ResourceLocation name;
    private int enabled = this.isEnabledByDefault() ? 1 : 0;
    private final List<EventListener.EventStorage<? extends Event>> eventListeners = Lists.newArrayList();
    private final Map<String, ConfigOption<?>> configOptions = Maps.newHashMap();
    private final Map<ModConfig.Type, Boolean> typeToIsLoaded = Stream.of(ModConfig.Type.values()).collect(Collectors.toMap(Function.identity(), value -> false, (key1, key2) -> key1, () -> new EnumMap(ModConfig.Type.class)));

    @Override
    @Nonnull
    public final ResourceLocation getRegistryName() {
        Objects.requireNonNull(this.name, "Cannot get name for element, name not set");
        return this.name;
    }

    @Override
    @Nonnull
    public final AbstractElement setRegistryName(@Nonnull ResourceLocation name) {
        if (this.name != null) {
            throw new UnsupportedOperationException(String.format("Cannot set name %s for element, name already set as %s", name, this.name));
        }
        this.name = name;
        return this;
    }

    @Override
    public final String getDisplayName() {
        return Stream.of(this.getRegistryName().func_110623_a().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    protected String[] getIncompatibleMods() {
        return new String[0];
    }

    protected final boolean isIncompatibleModPresent() {
        return Stream.of(this.getIncompatibleMods()).anyMatch(modId -> ModList.get().isLoaded(modId));
    }

    @Override
    public final void setupGeneralConfig(OptionsBuilder builder) {
        if (!this.isPersistent()) {
            builder.define(this.getDisplayName(), this.isEnabledByDefault()).comment(this.getDescription()).sync(this::setEnabled);
        }
    }

    public final void setup() {
        try {
            ISidedElement.runSide((ISidedElement)((Object)this), ICommonElement::constructCommon, IClientElement::constructClient, IServerElement::constructServer);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Error during setup of element {}", (Object)this.getRegistryName(), (Object)e);
        }
    }

    public final void load(ParallelDispatchEvent evt) {
        this.typeToIsLoaded.put(evt instanceof FMLClientSetupEvent ? ModConfig.Type.CLIENT : (evt instanceof FMLDedicatedServerSetupEvent ? ModConfig.Type.SERVER : ModConfig.Type.COMMON), true);
        if (this.isIncompatibleModPresent()) {
            this.enabled = -1;
            return;
        }
        try {
            ISidedElement.loadSide((ISidedElement)((Object)this), evt, ICommonElement::setupCommon2, IClientElement::setupClient2, IServerElement::setupServer2);
            if (!this.isEnabled()) {
                return;
            }
            if (evt instanceof FMLCommonSetupEvent) {
                this.reloadEventListeners(true);
            }
            ISidedElement.loadSide((ISidedElement)((Object)this), evt, ICommonElement::loadCommon, IClientElement::loadClient, IServerElement::loadServer);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Error during loading of element {}", (Object)this.getRegistryName(), (Object)e);
        }
    }

    private void reload(boolean enable) {
        if (enable) {
            this.reloadEventListeners(true);
            ISidedElement.runSide((ISidedElement)((Object)this), ICommonElement::loadCommon, IClientElement::loadClient, IServerElement::loadServer);
        } else {
            this.reloadEventListeners(false);
            ISidedElement.runSide((ISidedElement)((Object)this), ICommonElement::unloadCommon, IClientElement::unloadClient, IServerElement::unloadServer);
        }
    }

    private void reloadEventListeners(boolean enable) {
        if (enable) {
            this.getEventListeners().forEach(EventListener.EventStorage::register);
        } else {
            this.getEventListeners().forEach(EventListener.EventStorage::unregister);
        }
    }

    protected boolean isPersistent() {
        return false;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled == 1;
    }

    private void setEnabled(boolean enabled) {
        this.setEnabled(enabled ? 1 : 0);
    }

    private void setEnabled(int enabled) {
        if (this.enabled != -1 && this.enabled != enabled) {
            this.enabled = enabled;
            if (this.isFullyLoaded()) {
                this.reload(enabled == 1);
            }
        }
    }

    protected final void disable() {
        this.setEnabled(-1);
        PuzzlesLib.LOGGER.warn("Detected issue in {} element: {}", (Object)this.getDisplayName(), (Object)"Disabling until game restart");
        if (this.isPersistent()) {
            PuzzlesLib.LOGGER.warn("{} is a persistent element", (Object)this.getDisplayName());
        }
    }

    @Override
    public final List<EventListener.EventStorage<? extends Event>> getEventListeners() {
        return this.eventListeners;
    }

    @Override
    public final void addOption(ConfigOption<?> option) {
        this.configOptions.put(String.join((CharSequence)".", option.getPath()), option);
    }

    @Override
    public final Optional<ConfigOption<?>> getOption(String ... path) {
        String singlePath = String.join((CharSequence)".", path);
        ConfigOption<?> option = this.configOptions.get(singlePath);
        if (option != null) {
            return Optional.of(option);
        }
        PuzzlesLib.LOGGER.error("Unable to get option at path {}: {}", (Object)singlePath, (Object)"Option not found");
        return Optional.empty();
    }

    @Override
    public final <T> Optional<T> getValue(String ... path) {
        return this.getOption(new String[0]).map(ConfigOption::get);
    }

    public Collection<ConfigOption<?>> getOptions() {
        return this.configOptions.values();
    }

    @Deprecated
    public boolean isLoaded() {
        return this.isFullyLoaded();
    }

    public boolean isFullyLoaded() {
        return this.isTypeLoaded(ModConfig.Type.COMMON) && (this.isTypeLoaded(ModConfig.Type.CLIENT) || this.isTypeLoaded(ModConfig.Type.SERVER));
    }

    public boolean isTypeLoaded(ModConfig.Type type) {
        return this.typeToIsLoaded.get(type);
    }

    public static AbstractElement fake(ResourceLocation name) {
        return new FakeElement(name);
    }

    private static class FakeElement
    extends AbstractElement
    implements ISidedElement {
        public FakeElement(ResourceLocation name) {
            this.setRegistryName(name);
        }

        @Override
        public String[] getDescription() {
            return new String[0];
        }
    }
}

