/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;

public class PieceTrickSmeltItem
extends PieceTrick {
    SpellParam<Entity> target;

    public PieceTrickSmeltItem(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 80);
        meta.addStat(EnumSpellStat.COST, 240);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        if (targetVal instanceof ItemEntity && targetVal.func_70089_S()) {
            ItemEntity eitem = (ItemEntity)targetVal;
            ItemStack stack = eitem.func_92059_d();
            ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(eitem.func_130014_f_(), stack);
            if (!result.func_190926_b()) {
                stack.func_190918_g(1);
                eitem.func_92058_a(stack);
                if (stack.func_190916_E() == 0) {
                    eitem.func_70106_y();
                }
                ItemEntity item = new ItemEntity(context.focalPoint.func_130014_f_(), eitem.func_226277_ct_(), eitem.func_226278_cu_(), eitem.func_226281_cx_(), result.func_77946_l());
                context.focalPoint.func_130014_f_().func_217376_c((Entity)item);
            }
        } else {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return null;
    }
}

