/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickSmeltBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Number> maxBlocks;

    public PieceTrickSmeltBlockSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 20.0));
        meta.addStat(EnumSpellStat.COST, (int)(96.0 + (maxBlocksVal - 1.0) * 64.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        int maxBlocksInt = this.getParamValue(context, this.maxBlocks).intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        ItemStack tool = context.tool;
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        Vector3 targetNorm = targetVal.copy().normalize();
        for (BlockPos blockPos : MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksInt)).toVec3D(), maxBlocksInt)) {
            Item item;
            Block block1;
            if (!context.isInRadius(Vector3.fromBlockPos(blockPos))) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            if (!context.focalPoint.func_130014_f_().func_175660_a(context.caster, blockPos)) {
                return null;
            }
            BlockState state = context.focalPoint.func_130014_f_().func_180495_p(blockPos);
            Block block = state.func_177230_c();
            ItemStack stack = new ItemStack((IItemProvider)block);
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, context.caster.field_70170_p, blockPos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(context.focalPoint.func_130014_f_(), stack);
            if (result.func_190926_b() || (block1 = Block.func_149634_a((Item)(item = result.func_77973_b()))) == Blocks.field_150350_a) continue;
            context.focalPoint.func_130014_f_().func_175656_a(blockPos, block1.func_176223_P());
            context.focalPoint.func_130014_f_().func_217379_c(2001, blockPos, Block.func_196246_j((BlockState)block1.func_176223_P()));
        }
        return null;
    }
}

