/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;

public class MessageSpellModified {
    private final BlockPos pos;
    private final Spell spell;

    public MessageSpellModified(BlockPos pos, Spell spell) {
        this.pos = pos;
        this.spell = spell;
    }

    public MessageSpellModified(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.spell = MessageSpellModified.readSpell(buf);
    }

    private static Spell readSpell(PacketBuffer buf) {
        CompoundNBT cmp = buf.func_150793_b();
        return Spell.createFromNBT(cmp);
    }

    private static void writeSpell(PacketBuffer buf, Spell spell) {
        CompoundNBT cmp = new CompoundNBT();
        if (spell != null) {
            spell.writeToNBT(cmp);
        }
        buf.func_150786_a(cmp);
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        MessageSpellModified.writeSpell(buf, this.spell);
    }

    public void receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)context.get()).getSender().field_70170_p.func_175625_s(this.pos);
            if (te instanceof TileProgrammer) {
                TileProgrammer tile = (TileProgrammer)te;
                if (tile.playerLock == null || tile.playerLock.isEmpty() || tile.playerLock.equals(((NetworkEvent.Context)context.get()).getSender().func_200200_C_().getString())) {
                    tile.spell = this.spell;
                    tile.onSpellChanged();
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
                }
            }
        });
    }
}

