/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class ItemExosuitController
extends Item
implements ISocketableController {
    private static final String TAG_SELECTED_CONTROL_SLOT = "selectedControlSlot";

    public ItemExosuitController(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (playerIn.func_225608_bj_()) {
            ItemStack[] stacks;
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), PsiSoundHandler.compileError, SoundCategory.PLAYERS, 0.25f, 1.0f);
            } else {
                playerIn.func_184609_a(hand);
            }
            for (ItemStack stack : stacks = this.getControlledStacks(playerIn, itemStackIn)) {
                stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).ifPresent(c -> c.setSelectedSlot(3));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
    }

    @Override
    public ItemStack[] getControlledStacks(PlayerEntity player, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
            if (armor.func_190926_b() || !ISocketable.isSocketable(armor)) continue;
            stacks.add(armor);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    @Override
    public int getDefaultControlSlot(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(TAG_SELECTED_CONTROL_SLOT);
    }

    @Override
    public void setSelectedSlot(PlayerEntity player, ItemStack stack, int controlSlot, int slot) {
        stack.func_196082_o().func_74768_a(TAG_SELECTED_CONTROL_SLOT, controlSlot);
        ItemStack[] stacks = this.getControlledStacks(player, stack);
        if (controlSlot < stacks.length && !stacks[controlSlot].func_190926_b()) {
            stacks[controlSlot].getCapability(PsiAPI.SOCKETABLE_CAPABILITY).ifPresent(cap -> cap.setSelectedSlot(slot));
        }
    }
}

