/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import vazkii.psi.api.cad.CADTakeEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.common.Psi;
import vazkii.psi.common.item.ItemCAD;

@Mod.EventBusSubscriber(modid="psi", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ContributorSpellCircleHandler {
    private static volatile Map<String, int[]> colormap = Collections.emptyMap();
    private static boolean startedLoading = false;

    public static void load(Properties props) {
        HashMap<String, int[]> m = new HashMap<String, int[]>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key).replace("#", "0x");
            try {
                int[] values = Stream.of(value.split(",")).mapToInt(el -> Integer.parseInt(el.substring(2), 16)).toArray();
                m.put(key, values);
            }
            catch (NumberFormatException e) {
                Psi.logger.log(Level.ERROR, "Contributor " + key + " has an invalid hexcode!");
            }
        }
        colormap = m;
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static int[] getColors(String name) {
        return colormap.getOrDefault(name, new int[]{1295871});
    }

    public static boolean isContributor(String name) {
        return colormap.containsKey(name);
    }

    @SubscribeEvent
    public static void onCadTake(CADTakeEvent event) {
        if (ContributorSpellCircleHandler.isContributor(event.getPlayer().func_200200_C_().getString().toLowerCase()) && !((ICAD)event.getCad().func_77973_b()).getComponentInSlot(event.getCad(), EnumCADComponent.DYE).func_190926_b()) {
            ItemStack dyeStack = ((ICAD)event.getCad().func_77973_b()).getComponentInSlot(event.getCad(), EnumCADComponent.DYE);
            ((ICADColorizer)dyeStack.func_77973_b()).setContributorName(dyeStack, event.getPlayer().func_200200_C_().getString());
            ItemCAD.setComponent(event.getCad(), dyeStack);
        }
    }

    @SubscribeEvent
    public static void craftColorizer(PlayerEvent.ItemCraftedEvent event) {
        if (ContributorSpellCircleHandler.isContributor(event.getPlayer().func_200200_C_().getString().toLowerCase()) && event.getCrafting().func_77973_b() instanceof ICADColorizer) {
            ((ICADColorizer)event.getCrafting().func_77973_b()).setContributorName(event.getCrafting(), event.getPlayer().func_200200_C_().getString());
        }
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Psi Contributor Spell Circle Loader Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(Psi.logger));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Psi/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorSpellCircleHandler.load(props);
                }
            }
            catch (IOException e) {
                Psi.logger.info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

