/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractEnergyProvider;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.block.ITankHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.fluid.Tank;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.magmator.MagmatorBlock;
import owmii.powah.config.generator.MagmatorConfig;

public class MagmatorTile
extends AbstractEnergyProvider<Tier, MagmatorConfig, MagmatorBlock>
implements IInventoryHolder,
ITankHolder {
    protected final Energy buffer = Energy.create((long)0L);
    protected boolean burning;

    public MagmatorTile(Tier variant) {
        super(Tiles.MAGMATOR, (Enum)variant);
        this.tank.setCapacity(4000).validate(stack -> PowahAPI.MAGMATIC_FLUIDS.containsKey(stack.getFluid())).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public MagmatorTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.energy.read(nbt, "energy_buffer", true, false);
        this.burning = nbt.func_74767_n("burning");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        this.energy.write(nbt, "energy_buffer", true, false);
        nbt.func_74757_a("burning", this.burning);
        return super.writeSync(nbt);
    }

    protected int postTick(World world) {
        if (!this.isRemote() && this.checkRedstone()) {
            long min;
            int fluidHeat;
            FluidStack fluid;
            boolean flag = false;
            if (this.buffer.isEmpty() && !this.tank.isEmpty() && PowahAPI.MAGMATIC_FLUIDS.containsKey((fluid = this.tank.getFluid()).getFluid()) && (fluidHeat = PowahAPI.getMagmaticFluidHeat(fluid.getFluid())) > 0) {
                int minStored = Math.min(this.tank.getFluidAmount(), 100);
                this.buffer.setStored((long)(minStored * fluidHeat / 100));
                this.buffer.setCapacity((long)(minStored * fluidHeat / 100));
                this.tank.drain(minStored, IFluidHandler.FluidAction.EXECUTE);
            }
            if ((min = Math.min(this.getGeneration(), this.buffer.getStored())) > 0L && this.energy.getEmpty() >= min) {
                this.energy.produce(min);
                this.buffer.consume(min);
                flag = true;
                this.sync(4);
            }
            if (this.burning != flag) {
                this.burning = flag;
                this.sync(4);
            }
        }
        return this.chargeItems(1) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    public Tank getTank() {
        return this.tank;
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean keepFluid() {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public boolean isBurning() {
        return this.burning;
    }
}

