/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.discharger;

import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.energy.Energy;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.discharger.EnergyDischargerBlock;
import owmii.powah.config.EnergyDischargerConfig;

public class EnergyDischargerTile
extends AbstractEnergyStorage<Tier, EnergyDischargerConfig, EnergyDischargerBlock>
implements IInventoryHolder {
    public EnergyDischargerTile(Tier variant) {
        super(Tiles.ENERGY_DISCHARGER, (Enum)variant);
        this.inv.add(7);
    }

    public EnergyDischargerTile() {
        this(Tier.STARTER);
    }

    protected int postTick(World world) {
        int extracted = 0;
        if (!this.isRemote()) {
            if (this.checkRedstone()) {
                for (int i = 0; i < this.inv.getSlots(); ++i) {
                    ItemStack stack = this.inv.getStackInSlot(i);
                    long amount = Math.min(this.getEnergyTransfer(), (long)Energy.getStored((ItemStack)stack));
                    long received = Math.min(this.getEnergyCapacity() - this.getEnergy().getStored(), amount);
                    int j = Energy.extract((ItemStack)stack, (long)received, (boolean)false);
                    this.energy.produce((long)j);
                    extracted += j;
                }
            }
            extracted = (int)((long)extracted + this.extractFromSides(world));
        }
        return extracted > 0 ? 5 : -1;
    }

    public boolean keepEnergy() {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        boolean[] b = new boolean[]{false};
        Energy.get((ItemStack)stack).ifPresent(storage -> {
            if (storage.canExtract()) {
                b[0] = storage.getEnergyStored() > 0;
            }
        });
        return b[0];
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public Transfer getTransferType() {
        return Transfer.EXTRACT;
    }
}

