/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.gui.PortalityAssetProvider;
import com.buuz135.portality.gui.button.PortalSaveButton;
import com.buuz135.portality.tile.ControllerTile;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.ScreenAddonScreen;
import com.hrznstudio.titanium.client.screen.addon.color.ColorPickerAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ChangeColorScreen
extends ScreenAddonScreen {
    private ControllerTile controllerTile;
    private TextFieldWidget textField;
    private int color;
    private ColorPickerAddon colorPickerAddon;
    private boolean textChangedManually;

    public ChangeColorScreen(ControllerTile tile) {
        super((IAssetProvider)PortalityAssetProvider.PROVIDER, false);
        this.controllerTile = tile;
        this.color = tile.getColor();
        this.textChangedManually = false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.textField = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.x + 14, this.y + 120, 80, 16, (ITextComponent)new StringTextComponent(""));
        this.textField.func_146189_e(true);
        this.textField.func_146185_a(true);
        this.textField.func_146203_f(6);
        this.textField.func_212954_a(s -> {
            if (this.textChangedManually) {
                this.textChangedManually = false;
                return;
            }
            if (s.length() > 0) {
                try {
                    int tempColor = 0xFF000000 | Integer.parseInt(s, 16);
                    if (tempColor != this.color) {
                        this.color = tempColor;
                        this.colorPickerAddon.setColor(this.color);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.updateColor(this.color);
        this.func_230481_d_((IGuiEventListener)this.textField);
        this.getAddons().add(new PortalSaveButton(this.x + 110, this.y + 116, this.controllerTile, "Save", this));
    }

    public void renderBackground(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/color_change.png"));
        Minecraft.func_71410_x().field_71462_r.func_238474_b_(stack, this.x, this.y, 0, 0, 175, 146);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.x + 13), (int)(this.y + 9), (int)(this.x + 15 + 100), (int)(this.y + 91), (int)-16739073);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.x + 123), (int)(this.y + 9), (int)(this.x + 121 + 40), (int)(this.y + 91), (int)-16739073);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.x + 13), (int)(this.y + 99), (int)(this.x + 13 + 148), (int)(this.y + 109), (int)-16739073);
        super.renderBackground(stack, mouseX, mouseY, partialTicks);
        this.textField.func_230431_b_(stack, mouseX, mouseY, partialTicks);
        AssetUtil.drawHorizontalLine((MatrixStack)stack, (int)(this.textField.field_230690_l_ - 1), (int)(this.textField.field_230690_l_ + this.textField.func_230998_h_()), (int)(this.textField.field_230691_m_ - 1), (int)-16739073);
        AssetUtil.drawHorizontalLine((MatrixStack)stack, (int)(this.textField.field_230690_l_ - 1), (int)(this.textField.field_230690_l_ + this.textField.func_230998_h_()), (int)(this.textField.field_230691_m_ + this.textField.func_238483_d_()), (int)-16739073);
        AssetUtil.drawVerticalLine((MatrixStack)stack, (int)(this.textField.field_230690_l_ - 1), (int)(this.textField.field_230691_m_ - 1), (int)(this.textField.field_230691_m_ + this.textField.func_238483_d_()), (int)-16739073);
        AssetUtil.drawVerticalLine((MatrixStack)stack, (int)(this.textField.field_230690_l_ + this.textField.func_230998_h_()), (int)(this.textField.field_230691_m_ - 1), (int)(this.textField.field_230691_m_ + this.textField.func_238483_d_()), (int)-16739073);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.textField.func_146178_a();
    }

    public List<IFactory<IScreenAddon>> guiAddons() {
        ArrayList<IFactory<IScreenAddon>> addons = new ArrayList<IFactory<IScreenAddon>>();
        addons.add(() -> {
            this.colorPickerAddon = new ColorPickerAddon(14, 10, this.color, this::updateColor);
            return this.colorPickerAddon;
        });
        return addons;
    }

    public void updateColor(int color) {
        this.color = color;
        if (this.textField != null) {
            this.textChangedManually = true;
            this.textField.func_146180_a(Integer.toHexString(color).substring(2));
        }
    }

    public int getColor() {
        return this.color;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.textField.func_231046_a_(keyCode, scanCode, modifiers) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

