/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.ponderjs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kotakotik.ponderjs.PonderJSMod;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.utility.Couple;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class PJSLocalization {
    protected static Function<ResourceLocation, String> langKeyForTag = PonderJSMod.staticOneArgMethod(PonderLocalization.class, "langKeyForTag", ResourceLocation.class);
    protected static Function<ResourceLocation, String> langKeyForTagDescription = PonderJSMod.staticOneArgMethod(PonderLocalization.class, "langKeyForTagDescription", ResourceLocation.class);

    public static void record(List<String> namespaces, List<ResourceLocation> tags, List<Couple<String>> scenes, JsonObject json) {
        JsonObject tempJson = new JsonObject();
        for (String namespace : namespaces) {
            PonderLocalization.record((String)namespace, (JsonObject)tempJson);
        }
        List tagsAsIds = tags.stream().map(langKeyForTag).collect(Collectors.toList());
        List tagsAsDescriptionIds = tags.stream().map(langKeyForTagDescription).collect(Collectors.toList());
        tempJson.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            String value = ((JsonElement)e.getValue()).getAsString();
            if (tagsAsIds.contains(key) || tagsAsDescriptionIds.contains(key) || scenes.stream().anyMatch(s -> PJSLocalization.sceneLangMatches((Couple<String>)s, key))) {
                json.addProperty(key, value);
            }
        });
    }

    public static JsonObject record(List<String> namespaces, List<ResourceLocation> tags, List<Couple<String>> scenes) {
        JsonObject json = new JsonObject();
        PJSLocalization.record(namespaces, tags, scenes, json);
        return json;
    }

    public static String getSceneLangId(Couple<String> scene) {
        return (String)scene.getFirst() + ".ponder." + (String)scene.getSecond();
    }

    public static boolean sceneLangMatches(Couple<String> scene, String textKey) {
        String l = PJSLocalization.getSceneLangId(scene);
        return textKey.startsWith(l + ".text_") || textKey.equals(l + ".header");
    }
}

