/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.ponderjs.api;

import com.kotakotik.ponderjs.PonderJS;
import com.kotakotik.ponderjs.PonderJSMod;
import com.simibubi.create.foundation.ponder.PonderRegistrationHelper;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.repack.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractPonderBuilder<T, S extends AbstractPonderBuilder<T, S, C>, C extends BiConsumer<?, ?>> {
    protected ResourceLocation name;
    protected List<T> items;
    protected Runnable function = () -> {
        String s = this.getStartMessage();
        if (s != null) {
            PonderJSMod.LOGGER.info(s);
        }
    };
    protected static List<String> added = new ArrayList<String>();

    protected abstract S getSelf();

    public AbstractPonderBuilder(ResourceLocation name, List<T> items) {
        this.name = name;
        this.items = items;
    }

    protected String getStartMessage() {
        return "Starting ponder registration \"" + this.name + "\" with items " + Arrays.toString(this.items.toArray());
    }

    protected String getName(String scene) {
        return this.name.toString().replace(":", ".") + "." + scene;
    }

    protected String getPathOnlyName(String scene) {
        return this.name.func_110623_a() + "." + scene;
    }

    protected String getName(String scene, T item) {
        return this.getName(scene) + "." + this.itemToString(item);
    }

    protected abstract ResourceLocation[] itemsToIdArray();

    protected S tag(String ... tags) {
        for (String tag : tags) {
            PonderRegistry.TAGS.forItems(this.itemsToIdArray()).add(PonderJS.getTagByName(tag).get());
        }
        return this.getSelf();
    }

    protected abstract ItemProviderEntry<?> getItemProviderEntry(T var1);

    protected abstract void programStoryBoard(C var1, SceneBuilder var2, SceneBuildingUtil var3);

    protected S addStoryBoard(T item, ResourceLocation schematic, PonderStoryBoardEntry.PonderStoryBoard scene) {
        new PonderRegistrationHelper(this.name.func_110624_b()).forComponents(new ItemProviderEntry[]{this.getItemProviderEntry(item)}).addStoryBoard(schematic, scene);
        return this.getSelf();
    }

    protected S addNamedStoryBoard(String name, String displayName, T item, ResourceLocation schematic, PonderStoryBoardEntry.PonderStoryBoard scene) {
        String cacheName = this.getName(name, item);
        if (added.contains(cacheName)) {
            return this.getSelf();
        }
        added.add(cacheName);
        return this.addStoryBoard(item, schematic, (builder, util) -> {
            builder.title(name, displayName);
            scene.program(builder, util);
        });
    }

    protected abstract String itemToString(T var1);

    protected abstract C createConsumer(BiConsumer<SceneBuilder, SceneBuildingUtil> var1);
}

