/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.ponderjs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.kotakotik.ponderjs.PJSLocalization;
import com.kotakotik.ponderjs.PonderItemTagEventJS;
import com.kotakotik.ponderjs.PonderJSMod;
import com.kotakotik.ponderjs.PonderJSResourcePack;
import com.kotakotik.ponderjs.PonderRegistryEventJS;
import com.kotakotik.ponderjs.PonderTagRegistryEventJS;
import com.kotakotik.ponderjs.config.ModConfigs;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.ParrotElement;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.util.entry.ItemProviderEntry;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.architectury.hooks.PackRepositoryHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.antlr.v4.runtime.misc.Triple;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public class PonderJS {
    public static final HashMap<String, String> LANG = new HashMap();
    public static final List<String> namespaces = new ArrayList<String>();
    public static final List<ResourceLocation> tags = new ArrayList<ResourceLocation>();
    public static final List<Couple<String>> scenes = new ArrayList<Couple<String>>();
    public static final HashMap<String, AllIcons> cachedIcons = new HashMap();
    public static PonderRegistryEventJS ponderEvent;
    public static PonderTagRegistryEventJS tagRegistryEvent;
    public static PonderItemTagEventJS tagItemEvent;
    public static IEventBus modEventBus;

    static void clientPluginInit() {
        ponderEvent = new PonderRegistryEventJS();
        tagRegistryEvent = new PonderTagRegistryEventJS();
        tagItemEvent = new PonderItemTagEventJS();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ponderEvent::register);
    }

    static void clientModInit() {
        modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ModConfigs::onLoad);
        modEventBus.addListener(ModConfigs::onReload);
        ModConfigs.register();
    }

    static void addBindings(BindingsEvent event) {
        event.add("PonderPalette", PonderPalette.class);
        event.add("ParrotElement", ParrotElement.class);
        event.add("PonderInputWindowElement", InputWindowElement.class);
        event.add("PonderInput", InputWindowElement.class);
        event.add("PonderIcons", AllIcons.class);
        event.add("PonderPointing", Pointing.class);
    }

    static void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(Selection.class, o -> {
            if (o instanceof Selection) {
                return (Selection)o;
            }
            if (o instanceof MutableBoundingBox) {
                return Selection.of((MutableBoundingBox)((MutableBoundingBox)o));
            }
            if (o instanceof BlockPos) {
                return Selection.of((MutableBoundingBox)new MutableBoundingBox((Vector3i)((BlockPos)o), (Vector3i)BlockPos.field_177992_a));
            }
            return Selection.of((MutableBoundingBox)new MutableBoundingBox(0, 0, 0, 0, 0, 0));
        });
        typeWrappers.register(AllIcons.class, o -> {
            if (o instanceof AllIcons) {
                return (AllIcons)o;
            }
            return PonderJS.getIconByName(o.toString());
        });
    }

    public static Triple<Boolean, ITextComponent, Integer> generateJsonLang(HashMap<String, String> from) {
        Logger log = PonderJSMod.LOGGER;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(ModConfigs.CLIENT.getLangPath());
        JsonObject json = new JsonObject();
        if (file.exists()) {
            log.info("Found KubeJS lang, reading!");
            try {
                json = (JsonObject)gson.fromJson(FileUtils.readFileToString((File)file, (String)"UTF-8"), JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        JsonObject finalJson = json;
        ArrayList wrote = new ArrayList();
        from.forEach((key, value) -> {
            if (!finalJson.has(key) || !finalJson.get(key).getAsString().equals(value)) {
                log.info("Writing KubeJS lang key " + key);
                finalJson.addProperty(key, value);
                wrote.add(key);
            }
        });
        String j = gson.toJson(wrote);
        try {
            FileUtils.writeStringToFile((File)file, (String)gson.toJson((JsonElement)finalJson), (String)"UTF-8");
            String c = "Wrote " + wrote.size() + " KubeJS lang keys";
            log.info(c);
            if (wrote.size() > 0) {
                log.info(j);
            }
            return new Triple((Object)true, (Object)new StringTextComponent(c), (Object)wrote.size());
        }
        catch (IOException e) {
            log.error("Couldn't write KubeJS lang");
            e.printStackTrace();
            return new Triple((Object)false, (Object)new StringTextComponent("Unable to write KubeJS lang: " + e.getClass().getSimpleName() + "\nMore info in logs"), (Object)wrote.size());
        }
    }

    public static void addLang(String key, String value) {
        LANG.put(key, value);
    }

    public static JsonObject getKubeJSAssetLang(Gson g) {
        JsonObject assetLang = new JsonObject();
        try {
            InputStreamReader reader = new InputStreamReader(Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("kubejs", "lang/" + (String)ModConfigs.CLIENT.lang.get() + ".json")).func_199027_b(), StandardCharsets.UTF_8);
            assetLang = (JsonObject)g.getAdapter(JsonObject.class).read(new JsonReader((Reader)reader));
        }
        catch (FileNotFoundException reader) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return assetLang;
    }

    public static void fillPonderLang(Gson gson) {
        LANG.clear();
        JsonObject json = new JsonObject();
        PonderLocalization.generateSceneLang();
        PJSLocalization.record(namespaces, tags, scenes, json);
        JsonObject assetLang = PonderJS.getKubeJSAssetLang(gson);
        json.entrySet().forEach(e -> {
            if (!assetLang.has((String)e.getKey()) || !assetLang.get((String)e.getKey()).equals(e.getValue())) {
                String key = (String)e.getKey();
                String val = ((JsonElement)e.getValue()).getAsString();
                PonderJS.addLang(key, val);
            }
        });
    }

    public static void fillPonderLang() {
        PonderJS.fillPonderLang(new GsonBuilder().setPrettyPrinting().create());
    }

    public static void generatePonderLang() {
        Gson g = new GsonBuilder().setPrettyPrinting().create();
        Minecraft mc = Minecraft.func_71410_x();
        PonderJS.fillPonderLang(g);
        if (LANG.size() > 0) {
            PonderJSMod.LOGGER.warn("Found missing ponder lang, registering resource pack and reloading\nMissing: " + g.toJson(LANG) + "\nKeys only: " + g.toJson(LANG.keySet()));
            ResourcePackList list = mc.func_195548_H();
            PonderJSResourcePack pack = new PonderJSResourcePack();
            PackRepositoryHooks.addSource((ResourcePackList)list, (IPackFinder)pack);
            Minecraft.func_71410_x().func_213237_g();
        } else {
            PonderJSMod.LOGGER.info("No ponder lang missing, skipping resource pack registration");
        }
    }

    public static Optional<PonderTag> getTagByName(ResourceLocation res) {
        return PonderRegistry.TAGS.getListedTags().stream().filter(tag -> tag.getId().equals((Object)res)).findFirst();
    }

    protected static ResourceLocation appendNamespaceToId(String namespace, String id) {
        if (!id.contains(":")) {
            id = namespace + ":" + id;
        }
        return new ResourceLocation(id);
    }

    public static ResourceLocation appendCreateToId(String tag) {
        return PonderJS.appendNamespaceToId("create", tag);
    }

    public static ResourceLocation appendKubeToId(String id) {
        return PonderJS.appendNamespaceToId("kubejs", id);
    }

    public static Optional<PonderTag> getTagByName(String tag) {
        return PonderJS.getTagByName(PonderJS.appendCreateToId(tag));
    }

    public static <T extends IForgeRegistryEntry<? super T> & IItemProvider> ItemProviderEntry<T> createItemProvider(RegistryObject<T> item) {
        return new ItemProviderEntry((AbstractRegistrate)Create.registrate(), item);
    }

    public static AllIcons getIconByName(String icon) {
        String str = icon.toUpperCase();
        if (!str.startsWith("I_")) {
            str = "I_" + str;
        }
        if (cachedIcons.containsKey(str)) {
            return cachedIcons.get(str);
        }
        Field f = ObfuscationReflectionHelper.findField(AllIcons.class, (String)str);
        try {
            cachedIcons.put(str, (AllIcons)f.get(null));
            cachedIcons.get(str);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

