/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.polymorph.client.selector.RecipeSelectorManager;

public class SPacketSendRecipes {
    private final List<String> recipes;
    private final String selected;
    private final int length;

    public SPacketSendRecipes(List<String> recipes, String selected) {
        this.recipes = recipes;
        this.selected = selected;
        this.length = recipes.size();
    }

    public static void encode(SPacketSendRecipes msg, PacketBuffer buf) {
        buf.writeInt(msg.length);
        for (String id : msg.recipes) {
            buf.func_180714_a(id);
        }
        buf.func_180714_a(msg.selected);
    }

    public static SPacketSendRecipes decode(PacketBuffer buf) {
        ArrayList<String> recipes = new ArrayList<String>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            recipes.add(buf.func_150789_c(Short.MAX_VALUE));
        }
        String selected = buf.func_150789_c(Short.MAX_VALUE);
        return new SPacketSendRecipes(recipes, selected);
    }

    public static void handle(SPacketSendRecipes msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
            if (clientPlayerEntity != null) {
                RecipeSelectorManager.getSelector().ifPresent(selector -> selector.setRecipes(new HashSet<String>(msg.recipes), clientPlayerEntity.field_70170_p, true, msg.selected));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

