/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModelPart;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BoneModelPart
extends ModelRenderer
implements AnimatedModelPart {
    private static final Vector4f TRANSFORM_VECTOR = new Vector4f();
    private static final Vector3f NORMAL_VECTOR = new Vector3f();
    private final BedrockGeometryModel parent;
    private final GeometryModelData.Bone bone;
    private final Set<BoneModelPart> children;
    private final Map<String, ObjectList<Quad>> quads;
    private final ObjectList<Polygon> polygons;
    private final Matrix4f copyPosition;
    private final Matrix3f copyNormal;
    private final AnimatedModelPart.AnimationPose animationPose;
    private boolean copyVanilla;

    public BoneModelPart(BedrockGeometryModel parent, GeometryModelData.Bone bone) {
        super((Model)parent, 0, 0);
        this.parent = parent;
        this.bone = bone;
        this.children = new HashSet<BoneModelPart>();
        this.quads = new Object2ObjectArrayMap();
        this.polygons = new ObjectArrayList();
        this.copyPosition = new Matrix4f();
        this.copyNormal = new Matrix3f();
        this.animationPose = new AnimatedModelPart.AnimationPose();
        this.resetTransform(false);
        Arrays.stream(bone.getCubes()).forEach(this::addCube);
        GeometryModelData.PolyMesh polyMesh = bone.getPolyMesh();
        if (polyMesh != null) {
            this.addPolyMesh(polyMesh);
        }
    }

    private static void addVertex(IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, Matrix4f matrix4f, Vertex vertex) {
        TRANSFORM_VECTOR.func_195911_a(vertex.x, vertex.y, vertex.z, 1.0f);
        TRANSFORM_VECTOR.func_229372_a_(matrix4f);
        builder.func_225588_a_(TRANSFORM_VECTOR.func_195910_a(), TRANSFORM_VECTOR.func_195913_b(), TRANSFORM_VECTOR.func_195914_c(), red, green, blue, alpha, vertex.u, vertex.v, packedOverlay, packedLight, NORMAL_VECTOR.func_195899_a(), NORMAL_VECTOR.func_195900_b(), NORMAL_VECTOR.func_195902_c());
    }

    private void addCube(GeometryModelData.Cube cube) {
        boolean mirror;
        boolean empty = true;
        for (Direction direction : Direction.values()) {
            if (cube.getUV(direction) == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return;
        }
        Vector3f origin = cube.getOrigin();
        Vector3f size = cube.getSize();
        float x = origin.func_195899_a() / 16.0f;
        float y = origin.func_195900_b() / 16.0f;
        float z = origin.func_195902_c() / 16.0f;
        float sizeX = size.func_195899_a() / 16.0f;
        float sizeY = size.func_195900_b() / 16.0f;
        float sizeZ = size.func_195902_c() / 16.0f;
        float inflate = (cube.isOverrideInflate() ? cube.getInflate() : this.bone.getInflate()) / 16.0f;
        float x1 = x + sizeX;
        float y1 = y + sizeY;
        float z1 = z + sizeZ;
        if ((x -= inflate) == (x1 += inflate) && (y -= inflate) == (y1 += inflate) && (z -= inflate) == (z1 += inflate)) {
            return;
        }
        boolean bl = mirror = cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror();
        if (mirror) {
            float f3 = x1;
            x1 = x;
            x = f3;
        }
        Vector3f rotation = cube.getRotation();
        Vector3f pivot = cube.getPivotX();
        float rotationX = rotation.func_195899_a();
        float rotationY = rotation.func_195900_b();
        float rotationZ = rotation.func_195902_c();
        float pivotX = pivot.func_195899_a() / 16.0f;
        float pivotY = -pivot.func_195900_b() / 16.0f;
        float pivotZ = pivot.func_195902_c() / 16.0f;
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_((double)pivotX, (double)pivotY, (double)pivotZ);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotationZ));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotationY));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotationX));
        matrixStack.func_227861_a_((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        if (y != y1) {
            if (x != x1) {
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z, x, y1, z, x, y, z, x1, y, z, Direction.NORTH);
                this.addFace(cube, matrix4f, matrix3f, x, y1, z1, x1, y1, z1, x1, y, z1, x, y, z1, Direction.SOUTH);
            }
            if (z != z1) {
                this.addFace(cube, matrix4f, matrix3f, x, y1, z, x, y1, z1, x, y, z1, x, y, z, Direction.EAST);
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x1, y1, z, x1, y, z, x1, y, z1, Direction.WEST);
            }
        }
        if (x != x1 && z != z1) {
            this.addFace(cube, matrix4f, matrix3f, x, y, z1, x1, y, z1, x1, y, z, x, y, z, Direction.DOWN);
            this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x, y1, z1, x, y1, z, x1, y1, z, Direction.UP);
        }
    }

    private void addPolyMesh(GeometryModelData.PolyMesh polyMesh) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_226591_a_();
        for (GeometryModelData.Poly poly : polyMesh.getPolys()) {
            Vertex[] vertices = new Vertex[polyMesh.getPolyType().getVertices()];
            Vector3f[] normals = new Vector3f[polyMesh.getPolyType().getVertices()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = this.getVertex(polyMesh, poly, matrix4f, i);
                normals[i] = polyMesh.getNormals()[poly.getNormals()[i]].func_229195_e_();
                normals[i].func_229192_b_(1.0f, -1.0f, 1.0f);
            }
            this.polygons.add((Object)new Polygon(vertices, normals));
        }
    }

    private Vertex getVertex(GeometryModelData.PolyMesh polyMesh, GeometryModelData.Poly poly, Matrix4f matrix4f, int index) {
        Vector3f position = polyMesh.getPositions()[poly.getPositions()[index]];
        Vector2f uv = polyMesh.getUvs()[poly.getUVs()[index]];
        return new Vertex(matrix4f, position.func_195899_a(), -position.func_195900_b(), position.func_195902_c(), polyMesh.isNormalizedUvs() ? uv.field_189982_i : uv.field_189982_i / this.parent.getTextureWidth(), 1.0f - (polyMesh.isNormalizedUvs() ? uv.field_189983_j : uv.field_189983_j / this.parent.getTextureHeight()));
    }

    private void addFace(GeometryModelData.Cube cube, Matrix4f matrix4f, Matrix3f matrix3f, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, Direction face) {
        GeometryModelData.CubeUV uv = cube.getUV(face);
        if (uv != null) {
            this.quads.computeIfAbsent(uv.getMaterialInstance(), __ -> new ObjectArrayList()).add((Object)new Quad(new Vertex[]{new Vertex(matrix4f, x0, -y0, z0, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x1, -y1, z1, uv.getU() / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x2, -y2, z2, uv.getU() / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight()), new Vertex(matrix4f, x3, -y3, z3, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight())}, matrix3f, uv.getMaterialInstance(), cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror(), face.func_176734_d()));
        }
    }

    public void resetTransform(boolean resetChildren) {
        Vector3f rotation = this.bone.getRotation();
        Vector3f pivot = this.bone.getPivot();
        this.field_78795_f = (float)Math.PI / 180 * rotation.func_195899_a();
        this.field_78796_g = (float)Math.PI / 180 * rotation.func_195900_b();
        this.field_78808_h = (float)Math.PI / 180 * rotation.func_195902_c();
        this.field_78800_c = pivot.func_195899_a();
        this.field_78797_d = -pivot.func_195900_b();
        this.field_78798_e = pivot.func_195902_c();
        this.copyPosition.func_226591_a_();
        this.copyNormal.func_226119_c_();
        this.animationPose.reset();
        if (resetChildren) {
            this.children.forEach(boneModelPart -> boneModelPart.resetTransform(true));
        }
        this.copyVanilla = false;
    }

    public void func_78792_a(ModelRenderer part) {
        if (part instanceof BoneModelPart) {
            this.children.add((BoneModelPart)part);
        } else {
            super.func_78792_a(part);
        }
    }

    public void func_228309_a_(MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.func_228309_a_(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
        if (!(!this.field_78806_j || !(alpha > 0.0f) || this.quads.isEmpty() && this.polygons.isEmpty() && this.children.isEmpty())) {
            matrixStack.func_227860_a_();
            this.func_228307_a_(matrixStack);
            if (this.copyVanilla) {
                matrixStack.func_227861_a_((double)(-this.field_78800_c / 16.0f), (double)(-this.field_78797_d / 16.0f), (double)(-this.field_78798_e / 16.0f));
            }
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            Matrix3f matrix3f = matrixStack.func_227866_c_().func_227872_b_();
            Collection quads = (Collection)this.quads.get(this.parent.getActiveMaterial());
            if (quads != null) {
                for (Quad quad : quads) {
                    NORMAL_VECTOR.func_195905_a(-quad.normal.func_195899_a(), quad.normal.func_195900_b(), -quad.normal.func_195902_c());
                    NORMAL_VECTOR.func_229188_a_(matrix3f);
                    for (Vertex vertex : quad.vertices) {
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            if ("poly_mesh.texture".equals(this.parent.getActiveMaterial())) {
                for (Polygon polygon : this.polygons) {
                    for (int i = 0; i < 4; ++i) {
                        int index = MathHelper.func_76125_a((int)i, (int)0, (int)(polygon.vertices.length - 1));
                        Vertex vertex = polygon.vertices[index];
                        Vector3f normal = polygon.normals[index];
                        NORMAL_VECTOR.func_195905_a(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
                        NORMAL_VECTOR.func_229188_a_(matrix3f);
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            for (ModelRenderer part : this.children) {
                part.func_228309_a_(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
            }
            matrixStack.func_227865_b_();
        }
    }

    public void func_217177_a(ModelRenderer part) {
        this.copyPosition.func_226591_a_();
        this.copyNormal.func_226119_c_();
        MatrixStack matrixStack = new MatrixStack();
        part.func_228307_a_(matrixStack);
        this.copyPosition.func_226595_a_(matrixStack.func_227866_c_().func_227870_a_());
        this.copyNormal.func_226118_b_(matrixStack.func_227866_c_().func_227872_b_());
        this.copyVanilla = !BoneModelPart.class.isAssignableFrom(part.getClass());
    }

    public void func_228307_a_(MatrixStack matrixStack) {
        matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(this.copyPosition);
        matrixStack.func_227866_c_().func_227872_b_().func_226118_b_(this.copyNormal);
        matrixStack.func_227861_a_((double)((this.animationPose.getPosition().func_195899_a() + this.field_78800_c) / 16.0f), (double)((-this.animationPose.getPosition().func_195900_b() + this.field_78797_d) / 16.0f), (double)((this.animationPose.getPosition().func_195902_c() + this.field_78798_e) / 16.0f));
        if (this.animationPose.getScale().hashCode() != 1333788672) {
            matrixStack.func_227862_a_(this.animationPose.getScale().func_195899_a(), this.animationPose.getScale().func_195900_b(), this.animationPose.getScale().func_195902_c());
        }
        if (this.field_78808_h + this.animationPose.getRotation().func_195902_c() != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.field_78808_h + (float)((double)(this.animationPose.getRotation().func_195902_c() / 180.0f) * Math.PI)));
        }
        if (this.field_78796_g + this.animationPose.getRotation().func_195900_b() != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_78796_g + (float)((double)(this.animationPose.getRotation().func_195900_b() / 180.0f) * Math.PI)));
        }
        if (this.field_78795_f + this.animationPose.getRotation().func_195899_a() != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.field_78795_f + (float)((double)(this.animationPose.getRotation().func_195899_a() / 180.0f) * Math.PI)));
        }
        matrixStack.func_227861_a_((double)(-this.field_78800_c / 16.0f), (double)(-this.field_78797_d / 16.0f), (double)(-this.field_78798_e / 16.0f));
    }

    public GeometryModelData.Bone getBone() {
        return this.bone;
    }

    @Override
    public AnimatedModelPart.AnimationPose getAnimationPose() {
        return this.animationPose;
    }

    @Override
    public GeometryModelData.Locator[] getLocators() {
        return this.bone.getLocators();
    }

    private static class Vertex {
        private final float x;
        private final float y;
        private final float z;
        private final float u;
        private final float v;

        private Vertex(Matrix4f matrix4f, float x, float y, float z, float u, float v) {
            TRANSFORM_VECTOR.func_195911_a(x, y, z, 1.0f);
            TRANSFORM_VECTOR.func_229372_a_(matrix4f);
            this.x = TRANSFORM_VECTOR.func_195910_a();
            this.y = TRANSFORM_VECTOR.func_195913_b();
            this.z = TRANSFORM_VECTOR.func_195914_c();
            this.u = u;
            this.v = v;
        }
    }

    private static class Polygon {
        private final Vertex[] vertices;
        private final Vector3f[] normals;

        public Polygon(Vertex[] vertices, Vector3f[] normals) {
            this.vertices = vertices;
            this.normals = normals;
        }
    }

    private static class Quad {
        private final Vertex[] vertices;
        private final Vector3f normal;
        private final String material;

        public Quad(Vertex[] vertices, Matrix3f normal, String material, boolean mirror, Direction direction) {
            this.vertices = vertices;
            this.material = material;
            if (mirror) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = vertices[j];
                    vertices[j] = vertices[i - 1 - j];
                    vertices[i - 1 - j] = vertex;
                }
            }
            this.normal = direction.func_229386_k_();
            if (mirror) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
            this.normal.func_229188_a_(normal);
        }
    }
}

