/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import com.google.common.collect.Streams;
import gg.moonflower.pollen.pinwheel.api.client.animation.GeometryEntityRenderer;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimatedEntity;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectHandler;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class AnimatedEntityRenderer<T extends MobEntity>
extends GeometryEntityRenderer<T> {
    public AnimatedEntityRenderer(EntityRendererManager rendererManager, ResourceLocation model, float shadowSize) {
        super(rendererManager, model, shadowSize);
    }

    @Override
    @Nullable
    protected AnimationEffectHandler getEffectHandler(T entity) {
        return ((AnimatedEntity)entity).getAnimationEffects();
    }

    @Override
    protected float getBob(T entity, float partialTicks) {
        return ((AnimatedEntity)entity).isNoAnimationPlaying() ? (float)((MobEntity)entity).field_70173_aa + partialTicks : ((AnimatedEntity)entity).getRenderAnimationTick(partialTicks);
    }

    @Override
    public ResourceLocation[] getAnimations(T entity) {
        ResourceLocation[] animations;
        ResourceLocation[] resourceLocationArray = animations = ((AnimatedEntity)entity).isNoAnimationPlaying() ? ((AnimatedEntity)entity).getIdleAnimationState().getAnimations() : ((AnimatedEntity)entity).getAnimationState().getAnimations();
        if (((AnimatedEntity)entity).isAnimationTransitioning()) {
            return (ResourceLocation[])Streams.concat((Stream[])new Stream[]{Arrays.stream(animations), Arrays.stream(((AnimatedEntity)entity).getTransitionAnimationState().getAnimations())}).toArray(ResourceLocation[]::new);
        }
        return animations;
    }

    @Override
    public float[] getAnimationWeights(T entity) {
        return new float[0];
    }

    @Override
    public float[] getAnimationWeights(T entity, float partialTicks) {
        if (((AnimatedEntity)entity).isAnimationTransitioning()) {
            ResourceLocation[] animations = this.getAnimations(entity);
            float[] weights = new float[animations.length];
            int transitionAnimationStart = animations.length - ((AnimatedEntity)entity).getTransitionAnimationState().getAnimations().length;
            float transition = ((AnimatedEntity)entity).getRenderAnimationTransitionTick(partialTicks) / (float)((AnimatedEntity)entity).getAnimationTransitionLength();
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = i < transitionAnimationStart ? 1.0f - transition : transition;
            }
            return weights;
        }
        return new float[0];
    }
}

