/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.test;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.pollen.api.event.events.client.render.FogEvents;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import gg.moonflower.pollen.core.PollenTest;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class TestFluid
extends FlowingFluid
implements PollinatedFluid {
    private static final ResourceLocation STILL = new ResourceLocation("pollen", "block/void");
    private static final ResourceLocation FLOW = new ResourceLocation("pollen", "block/void_flow");

    @Override
    public ResourceLocation getStillTextureName() {
        return STILL;
    }

    @Override
    public ResourceLocation getFlowingTextureName() {
        return FLOW;
    }

    @Override
    public int getFogColor(ActiveRenderInfo camera, ClientWorld level, Biome biome, float partialTicks) {
        return 921104;
    }

    @Override
    public void applyFog(GameRenderer renderer, ActiveRenderInfo camera, FogEvents.FogContext context, float distance, float partialTicks) {
        context.fogEnd(1.0f);
        context.fogStart(0.2f);
        context.fogMode(9729);
        RenderSystem.setupNvFogDistance();
    }

    public Fluid func_210197_e() {
        return (Fluid)PollenTest.FLOWING_TEST_FLUID.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)PollenTest.TEST_FLUID.get();
    }

    public Item func_204524_b() {
        return PollenTest.TEST_BUCKET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World level, BlockPos pos, FluidState state, Random random) {
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.field_187633_N);
    }

    @Override
    public Optional<SoundEvent> getEmptySound() {
        return Optional.of(SoundEvents.field_203819_X);
    }

    protected boolean func_205579_d() {
        return true;
    }

    protected void func_205580_a(IWorld level, BlockPos pos, BlockState state) {
        TileEntity blockEntity = state.func_177230_c().func_235695_q_() ? level.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)level, (BlockPos)pos, (TileEntity)blockEntity);
    }

    public int func_185698_b(IWorldReader level) {
        return 4;
    }

    public BlockState func_204527_a(FluidState state) {
        return (BlockState)PollenTest.TEST.get().func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(TestFluid.func_207205_e((FluidState)state)));
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid == this.func_210198_f() || fluid == this.func_210197_e();
    }

    public int func_204528_b(IWorldReader level) {
        return 1;
    }

    public int func_205569_a(IWorldReader level) {
        return 40;
    }

    public boolean func_215665_a(FluidState fluidState, IBlockReader blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.func_207185_a(PollenTest.TEST_TAG);
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    @Override
    @Nullable
    public BlockState getInteractionState(World level, FluidState fluidState, BlockPos pos, BlockPos neighborPos) {
        return level.func_180495_p(neighborPos).func_203425_a(Blocks.field_150484_ah) ? Blocks.field_150475_bE.func_176223_P() : null;
    }

    public static class Source
    extends TestFluid {
        public int func_207192_d(FluidState state) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends TestFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

