/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.block.PollinatedLiquidBlock;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private final Set<ITag<Fluid>> wasInFluids = new HashSet<ITag<Fluid>>();
    @Shadow
    public World field_70170_p;
    @Shadow
    protected boolean field_70148_d;
    @Shadow
    @Final
    protected Random field_70146_Z;

    @Shadow
    public abstract BlockPos func_233580_cy_();

    @Shadow
    protected abstract void func_71061_d_();

    @Inject(method={"updateInWaterStateAndDoFluidPushing"}, at={@At(value="TAIL")}, cancellable=true)
    public void updateCustomFluids(CallbackInfoReturnable<Boolean> cir) {
        FluidBehaviorRegistry.getFluids().forEach(tag -> {
            if (FluidBehaviorRegistry.doFluidPushing((ITag<Fluid>)tag, (Entity)this)) {
                if (this.wasInFluids.add((ITag<Fluid>)tag) && !this.field_70148_d) {
                    this.func_71061_d_();
                }
            } else {
                this.wasInFluids.remove(tag);
            }
        });
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c();
        if (block instanceof PollinatedLiquidBlock) {
            cir.setReturnValue((Object)Float.valueOf(block.func_226891_m_()));
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void doCustomFluidSplashEffect(CallbackInfo ci) {
        FluidBehaviorRegistry.getFluids().stream().filter(this.wasInFluids::contains).forEach(tag -> {
            PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((ITag<Fluid>)tag));
            behavior.doSplashEffect((Entity)this, this.field_70146_Z);
            ci.cancel();
        });
    }
}

