/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge.compat.jei;

import com.google.common.collect.ImmutableSet;
import gg.moonflower.pollen.api.crafting.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.core.forge.compat.jei.PollenGrindstoneCategory;
import gg.moonflower.pollen.core.forge.compat.jei.PollenRecipeMaker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.GrindstoneScreen;
import net.minecraft.inventory.container.GrindstoneContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;

@JeiPlugin
@ApiStatus.Internal
public class PollenJeiPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = new ResourceLocation("pollen", "vanilla");
    public static final ResourceLocation GRINDSTONE_CATEGORY_ID = new ResourceLocation("pollen", "grindstone");
    @Nullable
    private PollenGrindstoneCategory grindstoneCategory;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.grindstoneCategory = new PollenGrindstoneCategory(guiHelper);
        iRecipeCategoryArray[0] = this.grindstoneCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Validate.notNull((Object)this.grindstoneCategory, (String)"grindstoneCategory", (Object[])new Object[0]);
        ImmutableSet potions = ImmutableSet.of((Object)Items.field_151068_bn, (Object)Items.field_185155_bH, (Object)Items.field_185156_bI);
        List<PollenBrewingRecipe> recipes = PollenRecipeMaker.getRecipes(null, PollenRecipeTypes.BREWING_TYPE.get());
        for (PollenBrewingRecipe recipe : recipes) {
            List<ItemStack> ingredients = Arrays.asList(recipe.getIngredient().func_193365_a());
            registration.addRecipes((Collection)potions.stream().map(item -> {
                ItemStack input = new ItemStack((IItemProvider)item);
                ItemStack result = new ItemStack((IItemProvider)item);
                PotionUtils.func_185188_a((ItemStack)input, (Potion)recipe.getFrom());
                PotionUtils.func_185188_a((ItemStack)result, (Potion)recipe.getResult());
                return registration.getVanillaRecipeFactory().createBrewingRecipe(ingredients, input, result);
            }).collect(Collectors.toList()), VanillaRecipeCategoryUid.BREWING);
        }
        registration.addRecipes(PollenRecipeMaker.getGrindstoneRecipes(this.grindstoneCategory, registration.getIngredientManager()), GRINDSTONE_CATEGORY_ID);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GrindstoneScreen.class, 95, 34, 22, 15, new ResourceLocation[]{GRINDSTONE_CATEGORY_ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(GrindstoneContainer.class, GRINDSTONE_CATEGORY_ID, 0, 2, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_222427_lP), new ResourceLocation[]{GRINDSTONE_CATEGORY_ID});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

