/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.entitlement.RenderableCosmetic;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelRenderer;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class PollenCosmeticLayer<T extends LivingEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    public PollenCosmeticLayer(IEntityRenderer<T, PlayerModel<T>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.func_82150_aj() || GeometryTextureManager.isReloading() || GeometryModelManager.isReloading()) {
            return;
        }
        EntitlementManager.getEntitlements(entity.func_110124_au()).forEach(entitlement -> {
            if (entitlement instanceof RenderableCosmetic) {
                RenderableCosmetic cosmetic = (RenderableCosmetic)((Object)entitlement);
                if (!cosmetic.isEnabled()) {
                    return;
                }
                ResourceLocation modelName = cosmetic.getModelKey();
                if (modelName == null) {
                    return;
                }
                GeometryModel model = GeometryModelManager.getModel(modelName);
                ResourceLocation textureKey = cosmetic.getTextureKey();
                if (model == GeometryModel.EMPTY || textureKey == null) {
                    return;
                }
                GeometryModelRenderer.copyModelAngles((Model)this.func_215332_c(), model);
                GeometryModelRenderer.render(model, textureKey, buffer, matrixStack, packedLight, OverlayTexture.field_229196_a_, cosmetic.getRed(), cosmetic.getGreen(), cosmetic.getBlue(), cosmetic.getAlpha());
            }
        });
    }
}

