/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement.type;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.type.AbstractHalo;
import gg.moonflower.pollen.core.client.screen.button.ArrayEntry;
import gg.moonflower.pollen.core.client.screen.button.EntitlementEntry;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DeveloperHalo
extends AbstractHalo {
    public static final Codec<DeveloperHalo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, AbstractHalo.HaloData.CODEC).fieldOf("halos").forGetter(halo -> halo.halos)).apply((Applicative)instance, DeveloperHalo::new));
    private final Map<String, AbstractHalo.HaloData> halos;
    private String type;
    private ResourceLocation textureKey;

    public DeveloperHalo(Map<String, AbstractHalo.HaloData> halos) {
        this.halos = halos;
    }

    @Override
    protected Entitlement copyData() {
        return new DeveloperHalo(this.halos);
    }

    @Override
    public void updateSettings(JsonObject settings) {
        super.updateSettings(settings);
        if (settings.has("halo_type")) {
            this.setType(JSONUtils.func_151200_h((JsonObject)settings, (String)"halo_type"));
        }
    }

    @Override
    public JsonObject saveSettings() {
        JsonObject settings = super.saveSettings();
        settings.addProperty("halo_type", this.type);
        return settings;
    }

    @Override
    public void addEntries(Consumer<EntitlementEntry> entryConsumer) {
        super.addEntries(entryConsumer);
        entryConsumer.accept(new ArrayEntry<String>((ITextComponent)new StringTextComponent("Type"), this, this::setType, this.type, this.halos.keySet().toArray(new String[0])).setDisplayGenerator(s -> s.toUpperCase(Locale.ROOT)));
    }

    @Override
    public Entitlement.Type getType() {
        return Entitlement.Type.DEVELOPER_HALO;
    }

    @Override
    public void registerTextures(BiConsumer<ResourceLocation, GeometryModelTextureTable> textureConsumer) {
        this.halos.forEach((key, value) -> {
            textureConsumer.accept(new ResourceLocation("pollen", key), value.getTextureTable());
            textureConsumer.accept(new ResourceLocation("pollen", key + "_emissive"), new GeometryModelTextureTable(value.getTextureTable().getTextureDefinitions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                GeometryModelTexture[] textures = new GeometryModelTexture[((GeometryModelTexture[])entry.getValue()).length];
                for (int i = 0; i < textures.length; ++i) {
                    GeometryModelTexture texture = ((GeometryModelTexture[])entry.getValue())[i];
                    textures[i] = GeometryModelTexture.texture(texture).setGlowing(true).build();
                }
                return textures;
            }))));
        });
    }

    @Override
    @Nullable
    public ResourceLocation getTextureKey() {
        return this.textureKey;
    }

    @Override
    @Nullable
    protected AbstractHalo.HaloData getData() {
        return this.halos.get(this.type);
    }

    @Override
    public String[] getModelUrls() {
        return (String[])this.halos.values().stream().map(AbstractHalo.HaloData::getModelUrl).toArray(String[]::new);
    }

    public void setType(String type) {
        this.type = type;
        this.textureKey = new ResourceLocation("pollen", type + (this.isEmissive() ? "_emissive" : ""));
    }

    @Override
    public void setEmissive(boolean emissive) {
        super.setEmissive(emissive);
        this.textureKey = new ResourceLocation("pollen", this.type + (this.isEmissive() ? "_emissive" : ""));
    }
}

