/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.forge;

import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.core.extension.forge.FMLHandshakeHandlerExtensions;
import io.netty.util.AttributeKey;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollinatedForgePacketContext
implements PollinatedPacketContext {
    private final SimpleChannel channel;
    private final Supplier<NetworkEvent.Context> ctx;

    public PollinatedForgePacketContext(SimpleChannel channel, Supplier<NetworkEvent.Context> ctx) {
        this.channel = channel;
        this.ctx = ctx;
    }

    @Override
    public CompletableFuture<Void> enqueueWork(Runnable runnable) {
        return this.ctx.get().enqueueWork(runnable);
    }

    @Override
    public void waitFor(Future<?> future) {
        NetworkManager connection = this.getNetworkManager();
        if (connection.func_150729_e() instanceof FMLHandshakeHandlerExtensions) {
            ((FMLHandshakeHandlerExtensions)connection.channel().attr(AttributeKey.valueOf((String)"fml:handshake")).get()).pollen_addWait(future);
        }
    }

    @Override
    public void disconnect(ITextComponent message) {
        NetworkManager connection = this.getNetworkManager();
        switch (this.getDirection()) {
            case PLAY_SERVERBOUND: {
                connection.func_201058_a((IPacket)new SDisconnectPacket(message), future -> connection.func_150718_a(message));
                connection.func_150721_g();
                Platform.getRunningServer().ifPresent(server -> server.func_213167_f(() -> ((NetworkManager)connection).func_179293_l()));
                break;
            }
            case LOGIN_SERVERBOUND: {
                connection.func_201058_a((IPacket)new SDisconnectLoginPacket(message), future -> connection.func_150718_a(message));
                connection.func_150721_g();
                Platform.getRunningServer().ifPresent(server -> server.func_213167_f(() -> ((NetworkManager)connection).func_179293_l()));
                break;
            }
            case PLAY_CLIENTBOUND: 
            case LOGIN_CLIENTBOUND: {
                connection.func_150718_a(message);
            }
        }
    }

    @Override
    public void reply(PollinatedPacket<?> packet) {
        this.channel.reply(packet, this.ctx.get());
    }

    @Override
    public PollinatedPacketDirection getDirection() {
        NetworkDirection direction = this.ctx.get().getDirection();
        switch (direction) {
            case PLAY_TO_SERVER: {
                return PollinatedPacketDirection.PLAY_SERVERBOUND;
            }
            case PLAY_TO_CLIENT: {
                return PollinatedPacketDirection.PLAY_CLIENTBOUND;
            }
            case LOGIN_TO_SERVER: {
                return PollinatedPacketDirection.LOGIN_SERVERBOUND;
            }
            case LOGIN_TO_CLIENT: {
                return PollinatedPacketDirection.LOGIN_CLIENTBOUND;
            }
        }
        throw new IllegalStateException("Unknown network direction: " + direction);
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.ctx.get().getNetworkManager();
    }
}

