/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.entity;

import gg.moonflower.pollen.api.PollenRegistries;
import gg.moonflower.pollen.api.entity.PollenEntityTypes;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.PollinatedBoatItem;
import gg.moonflower.pollen.api.registry.PollinatedEntityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class PollinatedBoat
extends BoatEntity {
    private static final DataParameter<Integer> DATA_ID_TYPE = EntityDataManager.func_187226_a(PollinatedBoat.class, (IDataSerializer)DataSerializers.field_187192_b);

    public PollinatedBoat(EntityType<? extends BoatEntity> entityType, World level) {
        super(entityType, level);
    }

    public PollinatedBoat(World level, double d, double e, double f) {
        this(PollenEntityTypes.BOAT.get(), level);
        this.func_70107_b(d, e, f);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = d;
        this.field_70167_r = e;
        this.field_70166_s = f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getBoatPollenType() == null) {
            BoatEntity boat = new BoatEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            boat.func_82149_j((Entity)this);
            if (this.func_145818_k_()) {
                boat.func_200203_b(this.func_200201_e());
                boat.func_174805_g(this.func_174833_aM());
            }
            boat.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c((Entity)boat);
            if (this.func_184218_aH()) {
                boat.func_184205_a(this.func_184187_bx(), true);
            }
            for (Entity passenger : this.func_184188_bt()) {
                passenger.func_184205_a((Entity)boat, true);
            }
            this.func_70106_y();
        }
    }

    public Item func_184455_j() {
        PollinatedBoatType type = this.getBoatPollenType();
        return type != null ? PollinatedBoatItem.getBoatItem(type) : null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_ID_TYPE, (Object)-1);
    }

    protected void func_213281_b(CompoundNBT compound) {
        ResourceLocation id = PollenRegistries.BOAT_TYPE_REGISTRY.getKey(this.getBoatPollenType());
        if (id != null) {
            compound.func_74778_a("Type", id.toString());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setPollenType(PollenRegistries.BOAT_TYPE_REGISTRY.get(new ResourceLocation(compound.func_74779_i("Type"))));
        }
    }

    public void func_184458_a(BoatEntity.Type boatType) {
    }

    public BoatEntity.Type func_184453_r() {
        return BoatEntity.Type.OAK;
    }

    public IPacket<?> func_213297_N() {
        return PollinatedEntityRegistry.createSpawnEntityPacket((Entity)this);
    }

    public void setPollenType(@Nullable PollinatedBoatType boatType) {
        this.field_70180_af.func_187227_b(DATA_ID_TYPE, (Object)(boatType == null ? -1 : PollenRegistries.BOAT_TYPE_REGISTRY.getId(boatType)));
    }

    public PollinatedBoatType getBoatPollenType() {
        int id = (Integer)this.field_70180_af.func_187225_a(DATA_ID_TYPE);
        return id == -1 ? null : PollenRegistries.BOAT_TYPE_REGISTRY.byId(id);
    }
}

