/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.model;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.model.PollinatedModelGenerator;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.BlockModelWriter;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedBlockState;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollinatedModelProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Set<ModelGeneratorFactory> factories = new HashSet<ModelGeneratorFactory>();
    private final DataGenerator generator;
    private final String domain;

    public PollinatedModelProvider(DataGenerator generator, PollinatedModContainer container) {
        this.generator = generator;
        this.domain = container.getId();
    }

    public PollinatedModelProvider addGenerator(ModelGeneratorFactory factory) {
        this.factories.add(factory);
        return this;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashMap blockStates = new HashMap();
        Consumer<IFinishedBlockState> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.func_230524_a_();
            IFinishedBlockState blockState = blockStates.put(block, blockStateGenerator);
            if (blockState != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = new HashSet();
        BiConsumer<ResourceLocation, Supplier> modelOutput = (resourceLocation, supplier) -> {
            Supplier model = models.put(resourceLocation, supplier);
            if (model != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        Consumer<Item> skippedAutoModelsOutput = skippedAutoModels::add;
        this.factories.stream().map(factory -> factory.create(blockStateOutput, modelOutput, skippedAutoModelsOutput)).forEach(PollinatedModelGenerator::run);
        Registry.field_212618_g.forEach(block -> {
            if (!this.domain.equals(Registry.field_212618_g.func_177774_c(block).func_110624_b())) {
                return;
            }
            Item item = (Item)Item.field_179220_a.get(block);
            if (item != null) {
                if (skippedAutoModels.contains(item)) {
                    return;
                }
                ResourceLocation itemLocation = ModelsResourceUtil.func_240219_a_((Item)item);
                if (!models.containsKey(itemLocation)) {
                    models.put(itemLocation, new BlockModelWriter(ModelsResourceUtil.func_240221_a_((Block)block)));
                }
            }
        });
        this.saveCollection(cache, path, blockStates, PollinatedModelProvider::createBlockStatePath);
        this.saveCollection(cache, path, models, PollinatedModelProvider::createModelPath);
    }

    private <T> void saveCollection(DirectoryCache cache, Path rootPath, Map<T, ? extends Supplier<JsonElement>> objectToJsonMap, BiFunction<Path, T, Path> resolveObjectPath) {
        objectToJsonMap.forEach((object, supplier) -> {
            Path path = (Path)resolveObjectPath.apply(rootPath, object);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)supplier.get()), (Path)path);
            }
            catch (Exception var7) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)var7);
            }
        });
    }

    private static Path createBlockStatePath(Path rootPath, Block block) {
        ResourceLocation resourceLocation = Registry.field_212618_g.func_177774_c((Object)block);
        return rootPath.resolve("assets/" + resourceLocation.func_110624_b() + "/blockstates/" + resourceLocation.func_110623_a() + ".json");
    }

    private static Path createModelPath(Path rootPath, ResourceLocation modelLocation) {
        return rootPath.resolve("assets/" + modelLocation.func_110624_b() + "/models/" + modelLocation.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Block State Definitions";
    }

    @FunctionalInterface
    public static interface ModelGeneratorFactory {
        public PollinatedModelGenerator create(Consumer<IFinishedBlockState> var1, BiConsumer<ResourceLocation, Supplier<JsonElement>> var2, Consumer<Item> var3);
    }
}

