/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

public class PollenBrewingRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Potion from;
    private final Ingredient ingredient;
    private final Potion result;

    public PollenBrewingRecipe(ResourceLocation id, String group, Potion from, Ingredient ingredient, Potion result) {
        this.id = id;
        this.group = group;
        this.from = from;
        this.ingredient = ingredient;
        this.result = result;
    }

    @ApiStatus.Internal
    public static PollenBrewingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
        String group = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"group", (String)"");
        Potion from = (Potion)Registry.field_212621_j.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"from")));
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"ingredient"));
        Potion result = (Potion)Registry.field_212621_j.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"result")));
        return new PollenBrewingRecipe(resourceLocation, group, from, ingredient, result);
    }

    @ApiStatus.Internal
    public static PollenBrewingRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
        String group = buf.func_218666_n();
        Potion from = (Potion)Registry.field_212621_j.func_82594_a(buf.func_192575_l());
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        Potion result = (Potion)Registry.field_212621_j.func_82594_a(buf.func_192575_l());
        return new PollenBrewingRecipe(id, group, from, ingredient, result);
    }

    @ApiStatus.Internal
    public static void toNetwork(PacketBuffer buf, PollenBrewingRecipe recipe) {
        buf.func_180714_a(recipe.group);
        buf.func_192572_a(Registry.field_212621_j.func_177774_c((Object)recipe.from));
        recipe.ingredient.func_199564_a(buf);
        buf.func_192572_a(Registry.field_212621_j.func_177774_c((Object)recipe.result));
    }

    public Potion getFrom() {
        return this.from;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Potion getResult() {
        return this.result;
    }

    public boolean func_77569_a(IInventory container, World level) {
        return false;
    }

    public ItemStack func_77572_b(IInventory container) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int w, int h) {
        return w >= 1 && h >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return PollenRecipeTypes.BREWING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PollenRecipeTypes.BREWING_TYPE.get();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient});
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Blocks.field_150382_bo);
    }
}

