/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.stb.STBImageWrite;

public final class TextureDownloader {
    private TextureDownloader() {
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, int texture) {
        GL11C.glBindTexture((int)3553, (int)texture);
        int base = GL11C.glGetTexParameteri((int)3553, (int)33084);
        int max = GL11C.glGetTexParameteri((int)3553, (int)33085);
        if (max == 1000) {
            max = 0;
        }
        ArrayList<CompletableFuture<Void>> result = new ArrayList<CompletableFuture<Void>>(max - base + 1);
        for (int level = base; level <= max; ++level) {
            Path outputFile = outputFolder.resolve(name + (base == max ? "" : "-" + level) + ".png");
            if (!Files.exists(outputFile, new LinkOption[0])) {
                try {
                    Files.createFile(outputFile, new FileAttribute[0]);
                }
                catch (Exception e) {
                    result.add(Util.func_215087_a((Throwable)e));
                    continue;
                }
            }
            int width = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
            ByteBuffer image = BufferUtils.createByteBuffer((int)(width * height * 4));
            GL11C.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)image);
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                if (!STBImageWrite.stbi_write_png((CharSequence)outputFile.toString(), (int)width, (int)height, (int)4, (ByteBuffer)image, (int)0)) {
                    throw new CompletionException(new IOException("Failed to write image to: " + outputFile));
                }
            }, Util.func_240992_g_());
            result.add(future);
        }
        return Util.func_215079_b(result);
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, Texture texture) {
        return TextureDownloader.save(name, outputFolder, texture.func_110552_b());
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, ResourceLocation texture) {
        Texture abstractTexture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(texture);
        return TextureDownloader.save(name, outputFolder, (Texture)(abstractTexture != null ? abstractTexture : MissingTextureSprite.func_195676_d()));
    }
}

