/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public final class ShapeRenderer {
    private static float zLevel = 0.0f;
    private static float red = 1.0f;
    private static float green = 1.0f;
    private static float blue = 1.0f;
    private static float alpha = 1.0f;

    private ShapeRenderer() {
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, float x, float y, float width, float height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, sprite.func_94209_e(), sprite.func_94206_g(), width, height, sprite.func_94212_f() - sprite.func_94209_e(), sprite.func_94210_h() - sprite.func_94206_g(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        ShapeRenderer.drawRectWithTexture(ShapeRenderer.begin(), matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
        ShapeRenderer.end();
    }

    public static IVertexBuilder begin() {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        return buffer;
    }

    public static void end() {
        Tessellator.func_178181_a().func_78381_a();
        zLevel = 0.0f;
        ShapeRenderer.resetColor();
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float width, float height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, sprite.func_94209_e(), sprite.func_94206_g(), width, height, sprite.func_94212_f() - sprite.func_94209_e(), sprite.func_94210_h() - sprite.func_94206_g(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        float scaleWidth = 1.0f / sourceWidth;
        float scaleHeight = 1.0f / sourceHeight;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix4f, x, y + height, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * scaleWidth, (v + textureHeight) * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, x + width, y + height, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, x + width, y, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + textureWidth) * scaleWidth, v * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, x, y, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * scaleWidth, v * scaleHeight).func_181675_d();
    }

    public static void drawSunburst(MatrixStack matrixStack, float x, float y, float width, float height, int segments) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float burstAngleOffset = (float)(Math.PI * (double)(1.0f / (float)segments / 2.0f));
        for (int i = 0; i < segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments + 1.5707963267948966);
            builder.func_227888_a_(matrix4f, x, y, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix4f, x + MathHelper.func_76134_b((float)(angle + burstAngleOffset)) * width / 2.0f, y + MathHelper.func_76126_a((float)(angle + burstAngleOffset)) * height / 2.0f, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix4f, x + MathHelper.func_76134_b((float)(angle - burstAngleOffset)) * width / 2.0f, y + MathHelper.func_76126_a((float)(angle - burstAngleOffset)) * height / 2.0f, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        ShapeRenderer.end();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void resetColor() {
        red = 1.0f;
        green = 1.0f;
        blue = 1.0f;
        alpha = 1.0f;
    }

    public static void setZLevel(float zLevel) {
        ShapeRenderer.zLevel = zLevel;
    }

    public static void setColor(float red, float green, float blue, float alpha) {
        ShapeRenderer.red = red;
        ShapeRenderer.green = green;
        ShapeRenderer.blue = blue;
        ShapeRenderer.alpha = alpha;
    }

    public static void setColor(int color) {
        red = (float)(color >> 16 & 0xFF) / 255.0f;
        green = (float)(color >> 8 & 0xFF) / 255.0f;
        blue = (float)(color & 0xFF) / 255.0f;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f;
    }
}

