/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.animation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;

public class AnimationData {
    public static final AnimationData EMPTY = new AnimationData("empty", Loop.NONE, MolangExpression.ZERO, 0.0f, false, new BoneAnimation[0], new SoundEffect[0], new ParticleEffect[0], new TimelineEffect[0]);
    private final String name;
    private final Loop loop;
    private final MolangExpression blendWeight;
    private final float animationLength;
    private final boolean overridePreviousAnimation;
    private final BoneAnimation[] boneAnimations;
    private final SoundEffect[] soundEffects;
    private final ParticleEffect[] particleEffects;
    private final TimelineEffect[] timelineEffects;

    public AnimationData(String name, Loop loop, MolangExpression blendWeight, float animationLength, boolean overridePreviousAnimation, BoneAnimation[] boneAnimations, SoundEffect[] soundEffects, ParticleEffect[] particleEffects, TimelineEffect[] timelineEffects) {
        this.name = name;
        this.loop = loop;
        this.blendWeight = blendWeight;
        this.animationLength = animationLength;
        this.overridePreviousAnimation = overridePreviousAnimation;
        this.boneAnimations = boneAnimations;
        this.soundEffects = soundEffects;
        this.particleEffects = particleEffects;
        this.timelineEffects = timelineEffects;
    }

    public String getName() {
        return this.name;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public MolangExpression getBlendWeight() {
        return this.blendWeight;
    }

    public float getAnimationLength() {
        return this.animationLength;
    }

    public boolean isOverridePreviousAnimation() {
        return this.overridePreviousAnimation;
    }

    public BoneAnimation[] getBoneAnimations() {
        return this.boneAnimations;
    }

    public SoundEffect[] getSoundEffects() {
        return this.soundEffects;
    }

    public ParticleEffect[] getParticleEffects() {
        return this.particleEffects;
    }

    public TimelineEffect[] getTimelineEffects() {
        return this.timelineEffects;
    }

    public String toString() {
        return "AnimationData{name='" + this.name + '\'' + ", loop=" + (Object)((Object)this.loop) + ", blendWeight=" + this.blendWeight + ", animationLength=" + this.animationLength + ", overridePreviousAnimation=" + this.overridePreviousAnimation + ", boneAnimations=" + Arrays.toString(this.boneAnimations) + ", soundEffects=" + Arrays.toString(this.soundEffects) + ", particleEffects=" + Arrays.toString(this.particleEffects) + ", timelineEffects=" + Arrays.toString(this.timelineEffects) + '}';
    }

    public static enum Loop {
        NONE,
        LOOP,
        HOLD_ON_LAST_FRAME;

    }

    public static class BoneAnimation {
        private final String name;
        private final KeyFrame[] positionFrames;
        private final KeyFrame[] rotationFrames;
        private final KeyFrame[] scaleFrames;

        public BoneAnimation(String name, KeyFrame[] positionFrames, KeyFrame[] rotationFrames, KeyFrame[] scaleFrames) {
            this.name = name;
            this.positionFrames = positionFrames;
            this.rotationFrames = rotationFrames;
            this.scaleFrames = scaleFrames;
        }

        public String getName() {
            return this.name;
        }

        public KeyFrame[] getPositionFrames() {
            return this.positionFrames;
        }

        public KeyFrame[] getRotationFrames() {
            return this.rotationFrames;
        }

        public KeyFrame[] getScaleFrames() {
            return this.scaleFrames;
        }

        public String toString() {
            return "BoneAnimation{name='" + this.name + '\'' + ", positionFrames=" + Arrays.toString(this.positionFrames) + ", rotationFrames=" + Arrays.toString(this.rotationFrames) + ", scaleFrames=" + Arrays.toString(this.scaleFrames) + '}';
        }
    }

    public static class SoundEffect {
        private final float time;
        private final String effect;
        private final MolangExpression pitch;
        private final MolangExpression volume;
        private final boolean loop;

        public SoundEffect(float time, String effect, MolangExpression pitch, MolangExpression volume, boolean loop) {
            this.time = time;
            this.effect = effect;
            this.pitch = pitch;
            this.volume = volume;
            this.loop = loop;
        }

        public float getTime() {
            return this.time;
        }

        public String getEffect() {
            return this.effect;
        }

        public MolangExpression getPitch() {
            return this.pitch;
        }

        public MolangExpression getVolume() {
            return this.volume;
        }

        public boolean isLoop() {
            return this.loop;
        }

        public String toString() {
            return "SoundEffect{time=" + this.time + ", effect='" + this.effect + '\'' + ", pitch='" + this.pitch + '\'' + ", volume='" + this.volume + '\'' + ", loop='" + this.loop + '\'' + '}';
        }
    }

    public static class ParticleEffect {
        private final float time;
        private final String effect;
        private final String locator;

        public ParticleEffect(float time, String effect, String locator) {
            this.time = time;
            this.effect = effect;
            this.locator = locator;
        }

        public float getTime() {
            return this.time;
        }

        public String getEffect() {
            return this.effect;
        }

        public String getLocator() {
            return this.locator;
        }

        public String toString() {
            return "ParticleEffect{time=" + this.time + ", effect='" + this.effect + '\'' + ", locator='" + this.locator + '\'' + '}';
        }
    }

    public static class TimelineEffect {
        private final float time;
        private final String data;

        public TimelineEffect(float time, String data) {
            this.time = time;
            this.data = data;
        }

        public float getTime() {
            return this.time;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return "TimelineEffect{time=" + this.time + ", data='" + this.data + '\'' + '}';
        }
    }

    public static class Deserializer
    implements JsonDeserializer<AnimationData[]> {
        private static Loop parseLoop(JsonElement json) {
            if (!json.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected Boolean or String, was " + JSONUtils.func_151222_d((JsonElement)json));
            }
            if (json.getAsJsonPrimitive().isBoolean()) {
                return json.getAsBoolean() ? Loop.LOOP : Loop.NONE;
            }
            if (json.getAsJsonPrimitive().isString()) {
                for (Loop loop : Loop.values()) {
                    if (!loop.name().equalsIgnoreCase(json.getAsString())) continue;
                    return loop;
                }
                throw new JsonSyntaxException("Unsupported loop: " + json.getAsString());
            }
            throw new JsonSyntaxException("Expected Boolean or String, was " + JSONUtils.func_151222_d((JsonElement)json));
        }

        private static void parseEffect(BiConsumer<Float, JsonElement> effectConsumer, JsonObject json, String name) {
            if (!json.has(name)) {
                return;
            }
            for (Map.Entry entry : json.getAsJsonObject(name).entrySet()) {
                try {
                    effectConsumer.accept(Float.valueOf(Float.parseFloat((String)entry.getKey())), (JsonElement)entry.getValue());
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException("Failed to parse " + name + " at time '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
        }

        private static void parseTransform(Collection<KeyFrame> frames, JsonObject json, String name, Supplier<MolangExpression[]> defaultValue) throws JsonParseException {
            if (!json.has(name)) {
                return;
            }
            JsonElement transformJson = json.get(name);
            if (transformJson.isJsonObject()) {
                for (Map.Entry entry : transformJson.getAsJsonObject().entrySet()) {
                    try {
                        float time = Float.parseFloat((String)entry.getKey());
                        if (frames.stream().anyMatch(keyFrame -> keyFrame.getTime() == time)) {
                            throw new JsonSyntaxException("Duplicate channel time '" + time + "'");
                        }
                        ChannelData data = Deserializer.parseChannel(transformJson.getAsJsonObject(), (String)entry.getKey(), defaultValue);
                        frames.add(new KeyFrame(time, data.lerpMode, data.pre[0], data.pre[1], data.pre[2], data.post[0], data.post[1], data.post[2]));
                    }
                    catch (NumberFormatException e) {
                        throw new JsonParseException("Invalid keyframe time '" + (String)entry.getKey() + "'", (Throwable)e);
                    }
                }
            } else {
                MolangExpression[] values = JSONTupleParser.getExpression(json, name, 3, defaultValue);
                frames.add(new KeyFrame(0.0f, LerpMode.LINEAR, values[0], values[1], values[2], values[0], values[1], values[2]));
            }
        }

        private static ChannelData parseChannel(JsonObject json, String name, Supplier<MolangExpression[]> defaultValue) throws JsonSyntaxException {
            if (!(json.has(name) || json.get(name).isJsonObject() || json.get(name).isJsonArray())) {
                throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonObject or JsonArray");
            }
            JsonElement transformationElement = json.get(name);
            if (transformationElement.isJsonObject()) {
                JsonObject transformationObject = transformationElement.getAsJsonObject();
                LerpMode lerpMode = LerpMode.LINEAR;
                if (transformationObject.has("lerp_mode")) {
                    lerpMode = null;
                    String mode = JSONUtils.func_151200_h((JsonObject)transformationObject, (String)"lerp_mode");
                    for (LerpMode m : LerpMode.values()) {
                        if (!m.name().toLowerCase(Locale.ROOT).equals(mode)) continue;
                        lerpMode = m;
                        break;
                    }
                    if (lerpMode == null) {
                        throw new JsonSyntaxException("Unknown Lerp Mode: " + mode);
                    }
                }
                MolangExpression[] post = JSONTupleParser.getExpression(transformationObject, "post", 3, null);
                return new ChannelData(JSONTupleParser.getExpression(transformationObject, "pre", 3, () -> post), post, lerpMode);
            }
            MolangExpression[] transformation = JSONTupleParser.getExpression(json, name, 3, defaultValue);
            return new ChannelData(transformation, transformation, LerpMode.LINEAR);
        }

        public AnimationData[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashSet<AnimationData> animations = new HashSet<AnimationData>();
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry animationEntry : jsonObject.entrySet()) {
                JsonObject animationObject = ((JsonElement)animationEntry.getValue()).getAsJsonObject();
                String animationName = (String)animationEntry.getKey();
                Loop loop = animationObject.has("loop") ? Deserializer.parseLoop(animationObject.get("loop")) : Loop.NONE;
                MolangExpression blendWeight = JSONTupleParser.getExpression(animationObject, "blend_weight", () -> MolangExpression.of(1.0f));
                float animationLength = JSONUtils.func_151221_a((JsonObject)animationObject, (String)"animation_length", (float)-1.0f);
                boolean overridePreviousAnimation = JSONUtils.func_151209_a((JsonObject)animationObject, (String)"override_previous_animation", (boolean)false);
                HashSet<BoneAnimation> bones = new HashSet<BoneAnimation>();
                ArrayList soundEffects = new ArrayList();
                ArrayList particleEffects = new ArrayList();
                ArrayList timlineEffects = new ArrayList();
                ArrayList<KeyFrame> positions = new ArrayList<KeyFrame>();
                ArrayList<KeyFrame> rotations = new ArrayList<KeyFrame>();
                ArrayList<KeyFrame> scales = new ArrayList<KeyFrame>();
                for (Map.Entry boneAnimationEntry : JSONUtils.func_152754_s((JsonObject)animationObject, (String)"bones").entrySet()) {
                    JsonObject boneAnimationObject = ((JsonElement)boneAnimationEntry.getValue()).getAsJsonObject();
                    Deserializer.parseTransform(positions, boneAnimationObject, "position", () -> new MolangExpression[]{MolangExpression.ZERO, MolangExpression.ZERO, MolangExpression.ZERO});
                    Deserializer.parseTransform(rotations, boneAnimationObject, "rotation", () -> new MolangExpression[]{MolangExpression.ZERO, MolangExpression.ZERO, MolangExpression.ZERO});
                    Deserializer.parseTransform(scales, boneAnimationObject, "scale", () -> new MolangExpression[]{MolangExpression.of(1.0f), MolangExpression.of(1.0f), MolangExpression.of(1.0f)});
                    positions.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    rotations.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    scales.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    bones.add(new BoneAnimation((String)boneAnimationEntry.getKey(), positions.toArray(new KeyFrame[0]), rotations.toArray(new KeyFrame[0]), scales.toArray(new KeyFrame[0])));
                    positions.clear();
                    rotations.clear();
                    scales.clear();
                }
                Deserializer.parseEffect((time, effectJson) -> {
                    JsonObject soundEffectsJson = JSONUtils.func_151210_l((JsonElement)effectJson, (String)"sound_effects");
                    soundEffects.add(new SoundEffect(time.floatValue(), JSONUtils.func_151200_h((JsonObject)soundEffectsJson, (String)"effect"), JSONTupleParser.getExpression(soundEffectsJson, "pitch", () -> MolangExpression.of(1.0f)), JSONTupleParser.getExpression(soundEffectsJson, "volume", () -> MolangExpression.of(1.0f)), JSONUtils.func_151209_a((JsonObject)soundEffectsJson, (String)"loop", (boolean)false)));
                }, animationObject, "sound_effects");
                Deserializer.parseEffect((time, effectJson) -> {
                    JsonObject particleEffectsJson = JSONUtils.func_151210_l((JsonElement)effectJson, (String)"particle_effects");
                    particleEffects.add(new ParticleEffect(time.floatValue(), JSONUtils.func_151200_h((JsonObject)particleEffectsJson, (String)"effect"), JSONUtils.func_151200_h((JsonObject)particleEffectsJson, (String)"locator")));
                }, animationObject, "particle_effects");
                Deserializer.parseEffect((time, effectJson) -> timlineEffects.add(new TimelineEffect(time.floatValue(), JSONUtils.func_151206_a((JsonElement)effectJson, (String)Float.toString(time.floatValue())))), animationObject, "timeline");
                soundEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                particleEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                timlineEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                animations.add(new AnimationData(animationName, loop, blendWeight, animationLength, overridePreviousAnimation, bones.toArray(new BoneAnimation[0]), soundEffects.toArray(new SoundEffect[0]), particleEffects.toArray(new ParticleEffect[0]), timlineEffects.toArray(new TimelineEffect[0])));
            }
            return animations.toArray(new AnimationData[0]);
        }

        private static class ChannelData {
            private final MolangExpression[] pre;
            private final MolangExpression[] post;
            private final LerpMode lerpMode;

            private ChannelData(MolangExpression[] pre, MolangExpression[] post, LerpMode lerpMode) {
                this.pre = pre;
                this.post = post;
                this.lerpMode = lerpMode;
            }
        }
    }

    public static class KeyFrame {
        private final float time;
        private final LerpMode lerpMode;
        private final MolangExpression transformPreX;
        private final MolangExpression transformPreY;
        private final MolangExpression transformPreZ;
        private final MolangExpression transformPostX;
        private final MolangExpression transformPostY;
        private final MolangExpression transformPostZ;

        public KeyFrame(float time, LerpMode lerpMode, MolangExpression transformPreX, MolangExpression transformPreY, MolangExpression transformPreZ, MolangExpression transformPostX, MolangExpression transformPostY, MolangExpression transformPostZ) {
            this.time = time;
            this.lerpMode = lerpMode;
            this.transformPreX = transformPreX;
            this.transformPreY = transformPreY;
            this.transformPreZ = transformPreZ;
            this.transformPostX = transformPostX;
            this.transformPostY = transformPostY;
            this.transformPostZ = transformPostZ;
        }

        public float getTime() {
            return this.time;
        }

        public LerpMode getLerpMode() {
            return this.lerpMode;
        }

        public MolangExpression getTransformPreX() {
            return this.transformPreX;
        }

        public MolangExpression getTransformPreY() {
            return this.transformPreY;
        }

        public MolangExpression getTransformPreZ() {
            return this.transformPreZ;
        }

        public MolangExpression getTransformPostX() {
            return this.transformPostX;
        }

        public MolangExpression getTransformPostY() {
            return this.transformPostY;
        }

        public MolangExpression getTransformPostZ() {
            return this.transformPostZ;
        }

        public String toString() {
            return "KeyFrame{time=" + this.time + ", transformPre=(" + this.transformPreX + ", " + this.transformPreY + ", " + this.transformPreZ + "), transformPost=" + this.transformPostX + "," + this.transformPostY + ", " + this.transformPostZ + ")" + '}';
        }
    }

    public static enum LerpMode implements Function<Float, Float>
    {
        LINEAR(x -> x),
        CATMULLROM(x -> x),
        EASE_IN_SINE(x -> Float.valueOf(1.0f - MathHelper.func_76134_b((float)(x.floatValue() * (float)Math.PI / 2.0f)))),
        EASE_OUT_SINE(x -> Float.valueOf(MathHelper.func_76126_a((float)(x.floatValue() * (float)Math.PI / 2.0f)))),
        EASE_IN_OUT_SINE(x -> Float.valueOf(-(MathHelper.func_76134_b((float)(x.floatValue() * (float)Math.PI)) - 1.0f) / 2.0f)),
        EASE_IN_QUAD(x -> Float.valueOf(x.floatValue() * x.floatValue())),
        EASE_OUT_QUAD(x -> {
            float a = 1.0f - x.floatValue();
            return Float.valueOf(1.0f - a * a);
        }),
        EASE_IN_OUT_QUAD(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(2.0f * x.floatValue() * x.floatValue());
            }
            float a = -2.0f * x.floatValue() + 2.0f;
            return Float.valueOf(1.0f - a * a / 2.0f);
        }),
        EASE_IN_CUBIC(x -> Float.valueOf(x.floatValue() * x.floatValue() * x.floatValue())),
        EASE_OUT_CUBIC(x -> {
            float a = 1.0f - x.floatValue();
            return Float.valueOf(1.0f - a * a * a);
        }),
        EASE_IN_OUT_CUBIC(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(4.0f * x.floatValue() * x.floatValue() * x.floatValue());
            }
            float a = -2.0f * x.floatValue() + 2.0f;
            return Float.valueOf(1.0f - a * a * a / 2.0f);
        }),
        EASE_IN_QUART(x -> Float.valueOf(x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue())),
        EASE_OUT_QUART(x -> {
            float a = 1.0f - x.floatValue();
            return Float.valueOf(1.0f - a * a * a * a);
        }),
        EASE_IN_OUT_QUART(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(8.0f * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue());
            }
            float a = -2.0f * x.floatValue() + 2.0f;
            return Float.valueOf(1.0f - a * a * a * a / 2.0f);
        }),
        EASE_IN_QUINT(x -> Float.valueOf(x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue())),
        EASE_OUT_QUINT(x -> {
            float a = 1.0f - x.floatValue();
            return Float.valueOf(1.0f - a * a * a * a * a);
        }),
        EASE_IN_OUT_QUINT(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(16.0f * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue());
            }
            float a = -2.0f * x.floatValue() + 2.0f;
            return Float.valueOf(1.0f - a * a * a * a * a / 2.0f);
        }),
        EASE_IN_EXPO(x -> Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0 * (double)x.floatValue() - 10.0))),
        EASE_OUT_EXPO(x -> Float.valueOf(x.floatValue() == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0 * (double)x.floatValue()))),
        EASE_IN_OUT_EXPO(x -> {
            if (x.floatValue() == 0.0f) {
                return Float.valueOf(0.0f);
            }
            if (x.floatValue() == 1.0f) {
                return Float.valueOf(1.0f);
            }
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf((float)Math.pow(2.0, 20.0 * (double)x.floatValue() - 10.0) / 2.0f);
            }
            return Float.valueOf((2.0f - (float)Math.pow(2.0, -20.0 * (double)x.floatValue() + 10.0)) / 2.0f);
        }),
        EASE_IN_CIRC(x -> Float.valueOf(1.0f - MathHelper.func_76129_c((float)(1.0f - x.floatValue() * x.floatValue())))),
        EASE_OUT_CIRC(x -> {
            float a = x.floatValue() - 1.0f;
            return Float.valueOf(MathHelper.func_76129_c((float)(1.0f - a * a)));
        }),
        EASE_IN_OUT_CIRC(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf((1.0f - MathHelper.func_76129_c((float)(1.0f - 4.0f * x.floatValue() * x.floatValue()))) / 2.0f);
            }
            float a = -2.0f * x.floatValue() + 2.0f;
            return Float.valueOf((MathHelper.func_76129_c((float)(1.0f - a * a)) + 1.0f) / 2.0f);
        }),
        EASE_IN_BACK(x -> Float.valueOf(2.70158f * x.floatValue() * x.floatValue() * x.floatValue() - 1.70158f * x.floatValue() * x.floatValue())),
        EASE_OUT_BACK(x -> {
            float a = x.floatValue() - 1.0f;
            return Float.valueOf(1.0f + 2.70158f * a * a * a + 1.70158f * a * a);
        }),
        EASE_IN_OUT_BACK(x -> {
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(4.0f * x.floatValue() * x.floatValue() * (7.189819f * x.floatValue() - 2.5949094f) / 2.0f);
            }
            float a = x.floatValue() - 2.0f;
            return Float.valueOf((4.0f * a * a * (3.5949094f * (x.floatValue() * 2.0f - 2.0f) + 2.5949094f) + 2.0f) / 2.0f);
        }),
        EASE_IN_ELASTIC(x -> {
            if (x.floatValue() == 0.0f) {
                return Float.valueOf(0.0f);
            }
            if (x.floatValue() == 1.0f) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf((float)(-Math.pow(2.0, 10.0 * (double)x.floatValue() - 10.0)) * MathHelper.func_76126_a((float)((x.floatValue() * 10.0f - 10.75f) * ((float)Math.PI * 2) / 3.0f)));
        }),
        EASE_OUT_ELASTIC(x -> {
            if (x.floatValue() == 0.0f) {
                return Float.valueOf(0.0f);
            }
            if (x.floatValue() == 1.0f) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf((float)Math.pow(2.0, -10.0 * (double)x.floatValue()) * MathHelper.func_76126_a((float)((x.floatValue() * 10.0f - 0.75f) * ((float)Math.PI * 2) / 3.0f)) + 1.0f);
        }),
        EASE_IN_OUT_ELASTIC(x -> {
            float c5 = 1.3962635f;
            if (x.floatValue() == 0.0f) {
                return Float.valueOf(0.0f);
            }
            if (x.floatValue() == 1.0f) {
                return Float.valueOf(1.0f);
            }
            if ((double)x.floatValue() < 0.5) {
                return Float.valueOf(-((float)Math.pow(2.0, 20.0 * (double)x.floatValue() - 10.0) * MathHelper.func_76126_a((float)((20.0f * x.floatValue() - 11.125f) * c5))) / 2.0f);
            }
            return Float.valueOf((float)Math.pow(2.0, -20.0 * (double)x.floatValue() + 10.0) * MathHelper.func_76126_a((float)((20.0f * x.floatValue() - 11.125f) * c5)) / 2.0f + 1.0f);
        }),
        EASE_OUT_BOUNCE(x -> {
            if ((double)x.floatValue() < 0.36363636363) {
                return Float.valueOf(7.5625f * x.floatValue() * x.floatValue());
            }
            if ((double)x.floatValue() < 0.72727272727) {
                x = Float.valueOf(x.floatValue() - 0.54545456f);
                return Float.valueOf(7.5625f * x.floatValue() * x.floatValue() + 0.75f);
            }
            if ((double)x.floatValue() < 0.90909090909) {
                x = Float.valueOf(x.floatValue() - 0.8181818f);
                return Float.valueOf(7.5625f * x.floatValue() * x.floatValue() + 0.9375f);
            }
            x = Float.valueOf(x.floatValue() - 0.95454544f);
            return Float.valueOf(7.5625f * x.floatValue() * x.floatValue() + 0.984375f);
        }),
        EASE_IN_BOUNCE(x -> Float.valueOf(1.0f - LerpMode.EASE_OUT_BOUNCE.function.apply(Float.valueOf(1.0f - x.floatValue())).floatValue())),
        EASE_IN_OUT_BOUNCE(x -> Float.valueOf((double)x.floatValue() < 0.5 ? (1.0f - LerpMode.EASE_OUT_BOUNCE.function.apply(Float.valueOf(1.0f - 2.0f * x.floatValue())).floatValue()) / 2.0f : (1.0f + LerpMode.EASE_OUT_BOUNCE.function.apply(Float.valueOf(2.0f * x.floatValue() - 1.0f)).floatValue()) / 2.0f));

        private final Function<Float, Float> function;

        private LerpMode(Function<Float, Float> function) {
            this.function = function;
        }

        @Override
        public Float apply(Float value) {
            return this.function.apply(Float.valueOf(MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f)));
        }
    }
}

