/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.animation;

import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.play.ClientboundSyncAnimationPacket;
import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectHandler;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectSource;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationState;
import gg.moonflower.pollen.pinwheel.core.client.animation.AnimationEffectSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface AnimatedEntity
extends AnimationEffectSource {
    public static <T extends Entity> void setAnimation(T entity, AnimationState animationState) {
        AnimatedEntity.setAnimation(entity, animationState, 0);
    }

    public static <T extends Entity> void setAnimation(T entity, AnimationState animationState, int duration) {
        World level = entity.field_70170_p;
        if (level.func_201670_d()) {
            return;
        }
        AnimationState before = ((AnimatedEntity)entity).getAnimationState();
        ((AnimatedEntity)entity).setAnimationState(animationState, duration);
        if (before != animationState) {
            PollenMessages.PLAY.sendToTracking(entity, new ClientboundSyncAnimationPacket(entity, duration));
        }
    }

    default public void animationTick() {
        if (!this.isAnimationTransitioning() && this.isNoAnimationPlaying()) {
            return;
        }
        AnimationState animationState = this.getAnimationState();
        int animationTick = this.getAnimationTick();
        if (animationTick == 0) {
            this.onAnimationStart(animationState);
        }
        this.setAnimationTick(animationTick + 1);
        int animationTransitionTick = this.getAnimationTransitionTick();
        if (this.isAnimationTransitioning()) {
            this.setAnimationTransitionTick(animationTransitionTick + 1);
            if (!this.isAnimationTransitioning()) {
                this.setAnimationState(this.getTransitionAnimationState(), 0);
            }
        } else if (animationTick >= animationState.getTickDuration() - 1) {
            this.resetAnimationState();
        }
    }

    default public void onAnimationStart(AnimationState state) {
        AnimationEffectHandler effectHandler = this.getAnimationEffects();
        if (effectHandler != null) {
            effectHandler.reset();
        }
    }

    default public void onAnimationStop(AnimationState state) {
    }

    default public void resetAnimationState() {
        this.resetAnimationState(0);
    }

    default public void resetAnimationState(int duration) {
        this.setAnimationState(AnimationState.EMPTY, duration);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void handleSoundEffect(AnimationData animation, AnimationData.SoundEffect soundEffect) {
        if (!(this instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)this;
        ResourceLocation sound = ResourceLocation.func_208304_a((String)soundEffect.getEffect());
        if (sound != null) {
            MolangRuntime runtime = MolangRuntime.runtime().create(1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new AnimationEffectSound(sound, entity.func_184176_by(), animation, entity, soundEffect.getPitch().safeResolve(runtime), soundEffect.getVolume().safeResolve(runtime), soundEffect.isLoop()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void handleParticleEffect(AnimationData animation, AnimationData.ParticleEffect particleEffect, double xOffset, double yOffset, double zOffset) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void handleTimelineEffect(AnimationData animation, AnimationData.TimelineEffect timelineEffect) {
    }

    public int getAnimationTick();

    public int getAnimationTransitionTick();

    public int getAnimationTransitionLength();

    default public float getRenderAnimationTick(float partialTicks) {
        return (float)this.getAnimationTick() + partialTicks;
    }

    default public float getRenderAnimationTransitionTick(float partialTicks) {
        return (float)this.getAnimationTransitionTick() + partialTicks;
    }

    public void setAnimationTick(int var1);

    public void setAnimationTransitionTick(int var1);

    public void setAnimationTransitionLength(int var1);

    public AnimationState getAnimationState();

    public AnimationState getTransitionAnimationState();

    default public AnimationState getIdleAnimationState() {
        return AnimationState.EMPTY;
    }

    public void setAnimationState(AnimationState var1);

    public void setTransitionAnimationState(AnimationState var1);

    default public void setAnimationState(AnimationState state, int duration) {
        this.setTransitionAnimationState(state);
        if (duration <= 0) {
            this.setAnimationState(state);
        } else {
            this.setAnimationTransitionLength(duration);
        }
        this.setAnimationTransitionTick(0);
    }

    @Nullable
    public AnimationEffectHandler getAnimationEffects();

    default public boolean isNoAnimationPlaying() {
        return this.getAnimationState() == AnimationState.EMPTY;
    }

    default public boolean isAnimationTransitioning() {
        return this.getAnimationTransitionTick() < this.getAnimationTransitionLength();
    }

    default public boolean isAnimationPlaying(AnimationState state) {
        return this.getAnimationState() == state;
    }

    public AnimationState[] getAnimationStates();
}

