/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.api;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.api.object.ImmutableMolangObject;
import gg.moonflower.pollen.molangcompiler.api.object.MolangObject;
import gg.moonflower.pollen.molangcompiler.core.object.MolangFunction;
import gg.moonflower.pollen.molangcompiler.core.object.MolangMath;
import gg.moonflower.pollen.molangcompiler.core.object.MolangVariableStack;
import gg.moonflower.pollen.molangcompiler.core.object.MolangVariableStorage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class MolangRuntime
implements MolangEnvironment {
    private final float thisValue;
    private final Map<String, MolangObject> objects;
    private final Set<String> aliases;
    private final Map<Integer, MolangExpression> parameters;

    private MolangRuntime(float thisValue, MolangObject query, MolangObject global, MolangObject variable) {
        this.thisValue = thisValue;
        this.objects = new HashMap<String, MolangObject>();
        this.aliases = new HashSet<String>();
        MolangVariableStack temp = new MolangVariableStack(false);
        this.objects.put("context", query);
        this.objects.put("query", query);
        this.objects.put("math", new MolangMath());
        this.objects.put("global", global);
        this.objects.put("temp", temp);
        this.objects.put("variable", variable);
        this.loadAlias("c", query);
        this.loadAlias("q", query);
        this.loadAlias("t", temp);
        this.loadAlias("v", variable);
        this.parameters = new HashMap<Integer, MolangExpression>();
    }

    public String dump() {
        StringBuilder builder = new StringBuilder("==Start MoLang Runtime Dump==\n\n");
        builder.append("==Start Objects==\n");
        for (Map.Entry<String, MolangObject> entry2 : this.objects.entrySet()) {
            if (this.aliases.contains(entry2.getKey())) continue;
            builder.append(entry2.getKey()).append('=').append(entry2.getValue()).append('\n');
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append("==End Objects==\n\n");
        builder.append("==Parameters==\n");
        this.parameters.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).forEach(entry -> builder.append("\tParameter ").append(entry.getKey()).append('=').append(entry.getValue()).append('\n'));
        builder.append("==End Parameters==\n\n");
        builder.append("==End MoLang Runtime Dump==");
        return builder.toString();
    }

    public void loadLibrary(String name, MolangObject object) {
        this.objects.put(name.toLowerCase(Locale.ROOT), object);
    }

    public void loadAlias(String name, MolangObject object) {
        this.objects.put(name.toLowerCase(Locale.ROOT), object);
        this.aliases.add(name);
    }

    @Override
    public void loadParameter(int index, MolangExpression expression) {
        this.parameters.put(index, expression);
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public float getThis() {
        return this.thisValue;
    }

    @Override
    public MolangObject get(String name) throws MolangException {
        if (!this.objects.containsKey(name = name.toLowerCase(Locale.ROOT))) {
            throw new MolangException("Unknown MoLang object: " + name);
        }
        return this.objects.get(name);
    }

    @Override
    public MolangExpression getParameter(int parameter) {
        return this.parameters.getOrDefault(parameter, MolangExpression.ZERO);
    }

    @Override
    public boolean hasParameter(int parameter) {
        return this.parameters.containsKey(parameter);
    }

    public static Builder runtime() {
        return new Builder();
    }

    public static class Builder {
        private final MolangObject query = new MolangVariableStorage(true);
        private final MolangObject global = new MolangVariableStorage(true);
        private final MolangObject variable = new MolangVariableStorage(false);

        public Builder setQuery(String name, float value) {
            this.query.set(name, MolangExpression.of(value));
            return this;
        }

        public Builder setQuery(String name, Supplier<Float> value) {
            this.query.set(name, MolangExpression.of(value));
            return this;
        }

        public Builder setQuery(String name, int params, MolangJavaFunction function) {
            this.query.set(params < 0 ? name : name + "$" + params, new MolangFunction(params, function));
            return this;
        }

        public Builder setGlobal(String name, float value) {
            this.global.set(name, MolangExpression.of(value));
            return this;
        }

        public Builder setGlobal(String name, Supplier<Float> value) {
            this.global.set(name, MolangExpression.of(value));
            return this;
        }

        public Builder setGlobal(String name, int params, MolangJavaFunction function) {
            this.global.set(params < 0 ? name : name + "$" + params, new MolangFunction(params, function));
            return this;
        }

        public Builder setVariable(String name, float value) {
            this.variable.set(name, MolangExpression.of(value));
            return this;
        }

        public Builder setVariables(MolangVariableProvider provider) {
            provider.addMolangVariables(new MolangVariableProvider.Context(){

                @Override
                public void addVariable(String name, float value) {
                    this.setVariable(name, value);
                }

                @Override
                public void addQuery(String name, float value) {
                    this.setQuery(name, value);
                }

                @Override
                public void addQuery(String name, Supplier<Float> value) {
                    this.setQuery(name, value);
                }

                @Override
                public void addQuery(String name, int params, MolangJavaFunction function) {
                    this.setQuery(name, params, function);
                }

                @Override
                public void removeVariable(String name) {
                    variable.set(name, MolangExpression.ZERO);
                }

                @Override
                public void removeQuery(String name) {
                    query.set(name, MolangExpression.ZERO);
                }
            });
            return this;
        }

        public MolangRuntime create(float thisValue) {
            return new MolangRuntime(thisValue, new ImmutableMolangObject(this.query), new ImmutableMolangObject(this.global), this.variable);
        }

        public MolangObject getQuery() {
            return this.query;
        }

        public MolangObject getGlobal() {
            return this.global;
        }

        public MolangObject getVariable() {
            return this.variable;
        }
    }
}

