/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.PollenClientPlayPacketHandler;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundUpdateSettingsPacket
implements PollinatedPacket<PollenClientPlayPacketHandler> {
    private final UUID player;
    private final String entitlement;
    private final JsonObject settings;

    public ClientboundUpdateSettingsPacket(PlayerEntity player, String entitlement, JsonObject settings) {
        this.player = player.func_110124_au();
        this.entitlement = entitlement;
        this.settings = settings;
    }

    public ClientboundUpdateSettingsPacket(PacketBuffer buf) throws IOException {
        this.player = buf.func_179253_g();
        this.entitlement = buf.func_218666_n();
        try {
            this.settings = new JsonParser().parse(buf.func_218666_n()).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.func_179252_a(this.player);
        buf.func_180714_a(this.entitlement);
        buf.func_180714_a(this.settings.toString());
    }

    @Override
    public void processPacket(PollenClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleUpdateSettingsPacket(this, ctx);
    }

    public UUID getPlayer() {
        return this.player;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public JsonObject getSettings() {
        return this.settings;
    }
}

