/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.command.PollenSuggestionProviders;
import gg.moonflower.pollen.api.command.argument.EnumArgument;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.core.command.forge.ConfigCommandImpl;
import java.io.File;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"config").then(Commands.func_197057_a((String)"showfile").then(Commands.func_197056_a((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(PollenSuggestionProviders.MOD_IDS).then(Commands.func_197056_a((String)"type", (ArgumentType)(dedicated ? EnumArgument.enumValues(PollinatedConfigType.COMMON, PollinatedConfigType.CLIENT) : EnumArgument.enumValues(PollinatedConfigType.values()))).executes(ctx -> {
            PollinatedConfigType type;
            String modId = StringArgumentType.getString((CommandContext)ctx, (String)"mod");
            String configFileName = ConfigCommand.getConfigFileName(modId, type = EnumArgument.getEnum(PollinatedConfigType.class, ctx, "type"));
            if (configFileName != null) {
                File f = new File(configFileName);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.pollen.config.success", new Object[]{modId, type, new StringTextComponent(f.getName()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())))}), false);
                return 1;
            }
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.pollen.config.fail", new Object[]{modId, type}));
            return 0;
        })))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getConfigFileName(String modId, PollinatedConfigType type) {
        void var1_1;
        return ConfigCommandImpl.getConfigFileName(modId, (PollinatedConfigType)var1_1);
    }
}

