/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.PollenRegistries;
import gg.moonflower.pollen.api.block.PollinatedLiquidBlock;
import gg.moonflower.pollen.api.block.PollinatedStandingSignBlock;
import gg.moonflower.pollen.api.block.PollinatedWallSignBlock;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootTableProvider;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.BucketItemBase;
import gg.moonflower.pollen.api.item.PollinatedBoatItem;
import gg.moonflower.pollen.api.item.SpawnEggItemBase;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import gg.moonflower.pollen.api.registry.PollinatedBlockRegistry;
import gg.moonflower.pollen.api.registry.PollinatedFluidRegistry;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.content.CompostablesRegistry;
import gg.moonflower.pollen.api.registry.content.DispenseItemBehaviorRegistry;
import gg.moonflower.pollen.api.registry.content.FlammabilityRegistry;
import gg.moonflower.pollen.api.registry.content.FlatteningRegistry;
import gg.moonflower.pollen.api.registry.content.FurnaceFuelRegistry;
import gg.moonflower.pollen.api.registry.resource.TagRegistry;
import gg.moonflower.pollen.core.Pollen;
import gg.moonflower.pollen.core.client.render.DebugPollenFlowerPotRenderer;
import gg.moonflower.pollen.core.datagen.TestBlockLootGenerator;
import gg.moonflower.pollen.core.test.TestFluid;
import gg.moonflower.pollen.core.test.TestPollenFluidBehavior;
import gg.moonflower.pollen.core.test.TestServerConfig;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenTest {
    private static final PollinatedRegistry<Item> ITEMS = PollenTest.create(() -> PollinatedRegistry.create(Registry.field_212630_s, "pollen"));
    private static final PollinatedBlockRegistry BLOCKS = PollenTest.create(() -> PollinatedRegistry.createBlock(ITEMS));
    private static final PollinatedFluidRegistry FLUIDS = PollenTest.create(() -> PollinatedRegistry.createFluid("pollen"));
    private static final PollinatedRegistry<PollinatedBoatType> BOATS = PollenTest.create(() -> PollinatedRegistry.create(PollenRegistries.BOAT_TYPE_REGISTRY, "pollen"));
    public static final Supplier<PollinatedBoatType> TEST_BOAT = PollenTest.create(() -> Objects.requireNonNull(BOATS).register("test_boat", () -> new PollinatedBoatType(new ResourceLocation("textures/entity/ghast/ghast.png"))));
    public static final ITag.INamedTag<Fluid> TEST_TAG = PollenTest.create(() -> TagRegistry.bindFluid(new ResourceLocation("pollen", "test")));
    public static final TestServerConfig SERVER_CONFIG = PollenTest.create(() -> ConfigManager.register("pollen", PollinatedConfigType.SERVER, TestServerConfig::new));
    public static final Supplier<FlowingFluid> TEST_FLUID = PollenTest.create(() -> Objects.requireNonNull(FLUIDS).register("test", TestFluid.Source::new));
    public static final Supplier<FlowingFluid> FLOWING_TEST_FLUID = PollenTest.create(() -> Objects.requireNonNull(FLUIDS).register("flowing_test", TestFluid.Flowing::new));
    public static final Supplier<Block> TEST = PollenTest.create(() -> Objects.requireNonNull(BLOCKS).register("test", () -> new PollinatedLiquidBlock(TEST_FLUID, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e())));
    public static final Supplier<Item> TEST_BUCKET = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test", () -> new BucketItemBase(TEST_FLUID, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f))));
    public static final Supplier<Item> TEST_SPAWN_EGG = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test_spawn_egg", () -> new SpawnEggItemBase<EntityType>(() -> EntityType.field_200757_aw, 0, 0, new Item.Properties().func_200916_a(ItemGroup.field_78026_f))));
    public static final Supplier<Item> TEST_BOAT_ITEM = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test_boat", () -> new PollinatedBoatItem(Objects.requireNonNull(TEST_BOAT), new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e))));
    public static final Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> TEST_SIGN = PollenTest.create(() -> Objects.requireNonNull(BLOCKS).registerSign("test", Material.field_151575_d, MaterialColor.field_151649_A));

    static void init() {
    }

    static void onClient() {
        BlockRendererRegistry.register(Blocks.field_150457_bL, (BlockRenderer)new DebugPollenFlowerPotRenderer());
    }

    static void onCommon() {
        Objects.requireNonNull(ITEMS).register(Pollen.PLATFORM);
        Objects.requireNonNull(BLOCKS).register(Pollen.PLATFORM);
        Objects.requireNonNull(FLUIDS).register(Pollen.PLATFORM);
        Objects.requireNonNull(BOATS).register(Pollen.PLATFORM);
        DispenseItemBehaviorRegistry.register((IItemProvider)Blocks.field_150484_ah, (source, stack) -> source.func_197524_h().func_180495_p(new BlockPos(DispenserBlock.func_149939_a((IBlockSource)source))).func_177230_c() == Blocks.field_150340_R, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                source.func_197524_h().func_180501_a(new BlockPos(DispenserBlock.func_149939_a((IBlockSource)source)), Blocks.field_150484_ah.func_176223_P(), 2);
                stack.func_190918_g(1);
                return stack;
            }
        });
        DispenseItemBehaviorRegistry.register((IItemProvider)Blocks.field_150484_ah, (source, stack) -> source.func_197524_h().func_180495_p(new BlockPos(DispenserBlock.func_149939_a((IBlockSource)source))).func_177230_c() == Blocks.field_150475_bE, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                source.func_197524_h().func_180501_a(new BlockPos(DispenserBlock.func_149939_a((IBlockSource)source)), Blocks.field_150340_R.func_176223_P(), 2);
                stack.func_190918_g(1);
                return stack;
            }
        });
        FluidBehaviorRegistry.register(TEST_TAG, new TestPollenFluidBehavior());
        FlatteningRegistry.register(Blocks.field_150475_bE, Blocks.field_150484_ah.func_176223_P());
        FlatteningRegistry.register(Blocks.field_150484_ah, Blocks.field_150475_bE.func_176223_P());
    }

    static void onClientPost(Platform.ModSetupContext context) {
    }

    static void onCommonPost(Platform.ModSetupContext context) {
        FlammabilityRegistry.register(Blocks.field_150484_ah, 200, 50);
        CompostablesRegistry.register((IItemProvider)Blocks.field_150354_m, 1.0f);
        FurnaceFuelRegistry.register((IItemProvider)Items.field_151133_ar, 100);
    }

    static void onData(Platform.DataSetupContext context) {
        DataGenerator generator = context.getGenerator();
        generator.func_200390_a((IDataProvider)new PollinatedLootTableProvider(generator).add(LootParameterSets.field_216261_b, new TestBlockLootGenerator()));
    }

    private static <T> T create(Supplier<T> factory) {
        return !Pollen.TESTS_ENABLED ? null : (T)factory.get();
    }
}

