/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.block.PollinatedStandingSignBlock;
import gg.moonflower.pollen.api.block.PollinatedWallSignBlock;
import gg.moonflower.pollen.api.item.PollinatedSignItem;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.WrapperPollinatedRegistry;
import gg.moonflower.pollen.api.registry.content.SignRegistry;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;

public class PollinatedBlockRegistry
extends WrapperPollinatedRegistry<Block> {
    private final PollinatedRegistry<Item> itemRegistry;

    PollinatedBlockRegistry(PollinatedRegistry<Block> blockRegistry, PollinatedRegistry<Item> itemRegistry) {
        super(blockRegistry);
        this.itemRegistry = itemRegistry;
    }

    public <R extends Block> Supplier<R> registerWithItem(String id, Supplier<R> block, Item.Properties properties) {
        return this.registerWithItem(id, block, (R object) -> new BlockItem(object, properties));
    }

    public <R extends Block> Supplier<R> registerWithItem(String id, Supplier<R> block, Function<R, Item> itemFactory) {
        Supplier register = this.register(id, block);
        this.itemRegistry.register(id, () -> (Item)itemFactory.apply((Block)register.get()));
        return register;
    }

    public Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> registerSign(String id, Material material, MaterialColor color) {
        return this.registerSign(id, AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c));
    }

    public Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> registerSign(String id, AbstractBlock.Properties blockProperties, Item.Properties itemProperties) {
        WoodType type = SignRegistry.register(new ResourceLocation(this.modId, id));
        Supplier<PollinatedStandingSignBlock> standing = this.register(id + "_sign", () -> new PollinatedStandingSignBlock(blockProperties, type));
        Supplier<PollinatedWallSignBlock> wall = this.register(id + "_wall_sign", () -> new PollinatedWallSignBlock(blockProperties.func_222379_b((Block)standing.get()), type));
        this.itemRegistry.register(id + "_sign", () -> new PollinatedSignItem(itemProperties, (Block)standing.get(), (Block)wall.get()));
        return Pair.of(standing, wall);
    }
}

