/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.event.events;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.event.PollinatedEvent;
import gg.moonflower.pollen.api.event.events.forge.LootTableConstructingEventImpl;
import gg.moonflower.pollen.api.registry.EventRegistry;
import gg.moonflower.pollen.core.mixin.loot.LootPoolAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootPoolBuilderAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableBuilderAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface LootTableConstructingEvent {
    public static final PollinatedEvent<LootTableConstructingEvent> EVENT = EventRegistry.create(LootTableConstructingEvent.class, events -> context -> {
        for (LootTableConstructingEvent event : events) {
            event.modifyLootTable(context);
        }
    });

    public void modifyLootTable(Context var1);

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<LootPool> getPools(LootTable lootTable) {
        return LootTableConstructingEventImpl.getPools(lootTable);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<LootEntry> getEntries(LootPool lootPool) {
        return LootTableConstructingEventImpl.getEntries(lootPool);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<ILootCondition> getConditions(LootPool lootPool) {
        return LootTableConstructingEventImpl.getConditions(lootPool);
    }

    public static class Context {
        private final LootTable source;
        private final ResourceLocation loadingId;
        private final LootTable.Builder builder;
        private final Map<Integer, LootPoolModifier> modifyPools;
        private final Set<Integer> removePools;
        private final Set<Integer> removeFunctions;
        private boolean changed;

        public Context(ResourceLocation loadingId, LootTable source) {
            this.loadingId = loadingId;
            this.source = source;
            this.builder = LootTable.func_216119_b().func_216039_a(source.func_216122_a());
            this.modifyPools = new HashMap<Integer, LootPoolModifier>();
            this.removePools = new HashSet<Integer>();
            this.removeFunctions = new HashSet<Integer>();
            ((LootTableBuilderAccessor)this.builder).getPools().addAll(LootTableConstructingEvent.getPools(source));
            ((LootTableBuilderAccessor)this.builder).getFunctions().addAll(Arrays.asList(((LootTableAccessor)source).getFunctions()));
        }

        private void updatePool(int index, Consumer<LootPool.Builder> action) {
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            LootPoolAccessor sourceAccessor = (LootPoolAccessor)pools.get(index);
            LootPool.Builder builder = LootPool.func_216096_a().func_216046_a(sourceAccessor.getPoolRolls());
            LootPoolBuilderAccessor accessor = (LootPoolBuilderAccessor)builder;
            accessor.getEntries().addAll(LootTableConstructingEvent.getEntries(pools.get(index)));
            accessor.getConditions().addAll(LootTableConstructingEvent.getConditions(pools.get(index)));
            accessor.getFunctions().addAll(Arrays.asList(sourceAccessor.getFunctions()));
            accessor.setBonusRolls(sourceAccessor.getBonusRolls());
            action.accept(builder);
            pools.set(index, builder.func_216044_b());
            this.changed = true;
        }

        private void removeFromPool(int index, Consumer<LootPoolModifier> action) {
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            action.accept(this.modifyPools.computeIfAbsent(index, __ -> new LootPoolModifier()));
            this.changed = true;
        }

        @ApiStatus.Internal
        public LootTable apply() {
            int j;
            if (!this.changed) {
                return this.source;
            }
            this.modifyPools.keySet().removeIf(this.removePools::contains);
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            List<ILootFunction> functions = ((LootTableBuilderAccessor)this.builder).getFunctions();
            for (Map.Entry<Integer, LootPoolModifier> entry : this.modifyPools.entrySet()) {
                int j2;
                int index = entry.getKey();
                if (index < 0 || index >= pools.size()) continue;
                LootPool pool = pools.get(index);
                LootPool.Builder poolBuilder = LootPool.func_216096_a();
                LootPoolAccessor poolAccessor = (LootPoolAccessor)pool;
                LootPoolBuilderAccessor builderAccessor = (LootPoolBuilderAccessor)poolBuilder;
                LootPoolModifier modifier = entry.getValue();
                builderAccessor.getEntries().addAll(LootTableConstructingEvent.getEntries(pool));
                builderAccessor.getConditions().addAll(LootTableConstructingEvent.getConditions(pool));
                builderAccessor.getFunctions().addAll(Arrays.asList(poolAccessor.getFunctions()));
                int[] removeEntriesArray = modifier.removeEntries.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeConditionsArray = modifier.removeConditions.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeFunctionsArray = modifier.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
                for (j2 = 0; j2 < removeEntriesArray.length; ++j2) {
                    builderAccessor.getEntries().remove(removeEntriesArray[removeEntriesArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeConditionsArray.length; ++j2) {
                    builderAccessor.getConditions().remove(removeConditionsArray[removeConditionsArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeFunctionsArray.length; ++j2) {
                    builderAccessor.getFunctions().remove(removeFunctionsArray[removeFunctionsArray.length - j2 - 1]);
                }
                pools.set(index, poolBuilder.func_216044_b());
            }
            int[] removePoolsArray = this.removePools.stream().mapToInt(i -> i).sorted().toArray();
            int[] removeFunctionsArray = this.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
            for (j = 0; j < removePoolsArray.length; ++j) {
                pools.remove(removePoolsArray[removePoolsArray.length - j - 1]);
            }
            for (j = 0; j < removeFunctionsArray.length; ++j) {
                functions.remove(removeFunctionsArray[removeFunctionsArray.length - j - 1]);
            }
            this.modifyPools.clear();
            this.removePools.clear();
            this.removeFunctions.clear();
            return this.builder.func_216038_b();
        }

        public void addPool(LootPool lootPool) {
            ((LootTableBuilderAccessor)this.builder).getPools().add(lootPool);
            this.changed = true;
        }

        public void addPool(LootPool.Builder lootPool) {
            this.builder.func_216040_a(lootPool);
            this.changed = true;
        }

        public void addFunction(ILootFunction function) {
            ((LootTableBuilderAccessor)this.builder).getFunctions().add(function);
            this.changed = true;
        }

        public void addFunction(ILootFunction.IBuilder function) {
            this.builder.func_212841_b_(function);
            this.changed = true;
        }

        public void setParamSet(LootParameterSet parameterSet) {
            this.builder.func_216039_a(parameterSet);
            this.changed = true;
        }

        public void insertPool(int poolIndex, LootPool ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (LootPool injectPool : pools) {
                    LootPoolAccessor injectPoolAccessor = (LootPoolAccessor)injectPool;
                    poolAccessor.getEntries().addAll(LootTableConstructingEvent.getEntries(injectPool));
                    poolAccessor.getConditions().addAll(LootTableConstructingEvent.getConditions(injectPool));
                    poolAccessor.getFunctions().addAll(Arrays.asList(injectPoolAccessor.getFunctions()));
                }
            });
        }

        public void insertPool(int poolIndex, LootPool.Builder ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (LootPool.Builder injectPool : pools) {
                    LootPoolBuilderAccessor injectPoolAccessor = (LootPoolBuilderAccessor)injectPool;
                    poolAccessor.getEntries().addAll(injectPoolAccessor.getEntries());
                    poolAccessor.getConditions().addAll(injectPoolAccessor.getConditions());
                    poolAccessor.getFunctions().addAll(injectPoolAccessor.getFunctions());
                }
            });
        }

        public void insertEntry(int poolIndex, LootEntry ... entries) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getEntries().addAll(Arrays.asList(entries)));
        }

        public void insertEntry(int poolIndex, LootEntry.Builder<?> ... entries) {
            this.updatePool(poolIndex, pool -> {
                for (LootEntry.Builder entry : entries) {
                    pool.func_216045_a(entry);
                }
            });
        }

        public void insertCondition(int poolIndex, ILootCondition ... conditions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getConditions().addAll(Arrays.asList(conditions)));
        }

        public void insertCondition(int poolIndex, ILootCondition.IBuilder ... conditions) {
            this.updatePool(poolIndex, pool -> {
                for (ILootCondition.IBuilder condition : conditions) {
                    pool.func_212840_b_(condition);
                }
            });
        }

        public void insertFunction(int poolIndex, ILootFunction ... functions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getFunctions().addAll(Arrays.asList(functions)));
        }

        public void insertFunction(int poolIndex, ILootFunction.IBuilder ... functions) {
            this.updatePool(poolIndex, pool -> {
                for (ILootFunction.IBuilder function : functions) {
                    pool.func_212841_b_(function);
                }
            });
        }

        public void removeEntry(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> ((LootPoolModifier)modifier).removeEntries.add(index));
        }

        public void removeCondition(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> ((LootPoolModifier)modifier).removeConditions.add(index));
        }

        public void removeFunction(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> ((LootPoolModifier)modifier).removeFunctions.add(index));
        }

        public void removePool(int index) {
            this.removePools.add(index);
            this.changed = true;
        }

        public void removeFunction(int index) {
            this.removeFunctions.add(index);
            this.changed = true;
        }

        public ResourceLocation getId() {
            return this.loadingId;
        }

        public LootTable getLootTable() {
            return this.source;
        }

        private static class LootPoolModifier {
            private final Set<Integer> removeEntries = new HashSet<Integer>();
            private final Set<Integer> removeConditions = new HashSet<Integer>();
            private final Set<Integer> removeFunctions = new HashSet<Integer>();

            private LootPoolModifier() {
            }
        }
    }
}

