/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.loot_table;

import com.google.common.collect.Sets;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootGenerator;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.mixin.loot.BlockLootAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;

public abstract class PollinatedBlockLootGenerator
extends BlockLootTables
implements PollinatedLootGenerator {
    private final String domain;

    public PollinatedBlockLootGenerator(PollinatedModContainer container) {
        this.domain = container.getId();
    }

    protected abstract void run();

    protected Collection<Block> blocks() {
        return Registry.field_212618_g.func_148742_b().stream().filter(name -> name.func_110624_b().equals(this.domain)).map(arg_0 -> ((DefaultedRegistry)Registry.field_212618_g).func_82594_a(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        this.run();
        Map<ResourceLocation, LootTable.Builder> map = ((BlockLootAccessor)((Object)this)).getMap();
        HashSet set = Sets.newHashSet();
        Collection<Block> blocks = this.blocks();
        for (Block block : blocks) {
            ResourceLocation resourceLocation = block.func_220068_i();
            if (resourceLocation == LootTables.field_186419_a || !set.add(resourceLocation)) continue;
            LootTable.Builder builder = map.remove(resourceLocation);
            if (builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourceLocation, Registry.field_212618_g.func_177774_c((Object)block)));
            }
            registry.accept(resourceLocation, builder);
        }
        if (!map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + map.keySet());
        }
    }
}

