/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedLanguageProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> keys = new TreeMap<String, String>();
    private final DataGenerator generator;
    protected final String domain;
    protected final String locale;

    public PollinatedLanguageProvider(DataGenerator generator, PollinatedModContainer container, String locale) {
        this.generator = generator;
        this.domain = container.getId();
        this.locale = locale;
    }

    protected abstract void registerTranslations();

    public void func_200398_a(DirectoryCache cache) {
        this.registerTranslations();
        Path path = this.generator.func_200391_b().resolve("assets/" + this.domain + "/lang/" + this.locale + ".json");
        try {
            JsonElement json = GSON.toJsonTree(this.keys);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save {}", (Object)path, (Object)e);
        }
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get().func_149739_a(), name);
    }

    public void addBlock(Block key, String name) {
        this.add(key.func_149739_a(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get().func_77658_a(), name);
    }

    public void addItem(Item key, String name) {
        this.add(key.func_77658_a(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get().func_210760_d(), name);
    }

    public void addEntityType(EntityType<?> key, String name) {
        this.add(key.func_210760_d(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get().func_77977_a(), name);
    }

    public void addItemStack(ItemStack key, String name) {
        this.add(key.func_77977_a(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get().func_77320_a(), name);
    }

    public void addEnchantment(Enchantment key, String name) {
        this.add(key.func_77320_a(), name);
    }

    public void addEffect(Supplier<? extends Effect> key, String name) {
        this.add(key.get().func_76393_a(), name);
    }

    public void addEffect(Effect key, String name) {
        this.add(key.func_76393_a(), name);
    }

    public void add(String key, String value) {
        if (this.keys.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public String func_200397_b() {
        return "Language: " + this.locale;
    }
}

