/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SkinHelper {
    private static final Map<GameProfile, CompletableFuture<GameProfile>> PROFILE_CACHE = new WeakHashMap<GameProfile, CompletableFuture<GameProfile>>();
    private static MinecraftSessionService sessionService;
    private static PlayerProfileCache gameProfileCache;

    private SkinHelper() {
    }

    @ApiStatus.Internal
    public static void init() {
        YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J());
        sessionService = authenticationservice.createMinecraftSessionService();
        gameProfileCache = new PlayerProfileCache(authenticationservice.createProfileRepository(), new File(Minecraft.func_71410_x().field_71412_D, MinecraftServer.field_152367_a.getName()));
    }

    private static CompletableFuture<GameProfile> guiUpdateGameProfile(GameProfile input) {
        if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
            return CompletableFuture.completedFuture(input);
        }
        if (StringUtils.func_151246_b((String)input.getName()) && input.getId() == null) {
            return CompletableFuture.completedFuture(input);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (StringUtils.func_151246_b((String)input.getName())) {
                GameProfile profile = gameProfileCache.func_152652_a(input.getId());
                if (profile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    profile = sessionService.fillProfileProperties(profile, true);
                }
                return profile;
            }
            GameProfile profile = gameProfileCache.func_152655_a(input.getName());
            if (profile == null) {
                return input;
            }
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                profile = sessionService.fillProfileProperties(profile, true);
            }
            return profile;
        }, Util.func_215072_e());
    }

    private static CompletableFuture<GameProfile> updateGameProfileFuture(GameProfile input) {
        return CompletableFuture.supplyAsync(() -> SkullTileEntity.func_174884_b((GameProfile)input), Util.func_215072_e());
    }

    @Nullable
    public static synchronized CompletableFuture<GameProfile> updateGameProfile(@Nullable GameProfile input) {
        if (input == null) {
            return null;
        }
        if (Minecraft.func_71410_x().field_71441_e == null || StringUtils.func_151246_b((String)input.getName())) {
            return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::guiUpdateGameProfile);
        }
        return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::updateGameProfileFuture);
    }

    public static void loadPlayerTexture(@Nullable GameProfile input, MinecraftProfileTexture.Type type, Consumer<ResourceLocation> consumer) {
        CompletableFuture.runAsync(() -> {
            if (input == null) {
                consumer.accept(DefaultPlayerSkin.func_177335_a());
                return;
            }
            Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(input);
            if (map.containsKey(type)) {
                RenderSystem.recordRenderCall(() -> consumer.accept(Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(type), type)));
            } else {
                consumer.accept(DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)input)));
            }
        }, Util.func_215072_e());
    }
}

