/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.worldgen;

import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModDecorators;
import me.desht.pneumaticcraft.common.core.ModFeatures;
import me.desht.pneumaticcraft.common.util.WildcardedRLMatcher;
import me.desht.pneumaticcraft.common.worldgen.OilLakePlacement;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModWorldGen {
    public static ConfiguredFeature<?, ?> OIL_LAKES;
    static WildcardedRLMatcher dimensionMatcher;
    static WildcardedRLMatcher biomeMatcher;

    public static void registerConfiguredFeatures() {
        Registry registry = WorldGenRegistries.field_243653_e;
        OIL_LAKES = ((Feature)ModFeatures.OIL_LAKE.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.OIL.get()).func_176223_P())).func_227228_a_(((OilLakePlacement)ModDecorators.OIL_LAKE.get()).func_227446_a_((IPlacementConfig)new ChanceConfig(ConfigHelper.getOilLakeChance())));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)PneumaticRegistry.RL("oil_lakes"), OIL_LAKES);
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (!ModWorldGen.isBiomeBlacklisted(event.getName()) && !((List)ConfigHelper.common().general.oilWorldGenCategoryBlacklist.get()).contains(event.getCategory().func_222352_a())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.LAKES, OIL_LAKES);
        }
    }

    public static void clearBlacklistCache() {
        dimensionMatcher = null;
        biomeMatcher = null;
    }

    static boolean isBiomeBlacklisted(ResourceLocation biomeName) {
        if (biomeMatcher == null) {
            biomeMatcher = new WildcardedRLMatcher((Collection)ConfigHelper.common().general.oilWorldGenBlacklist.get());
        }
        return biomeMatcher.test(biomeName);
    }

    static boolean isDimensionBlacklisted(ISeedReader level) {
        if (dimensionMatcher == null) {
            dimensionMatcher = new WildcardedRLMatcher((Collection)ConfigHelper.common().general.oilWorldGenDimensionBlacklist.get());
        }
        return dimensionMatcher.test(level.func_201672_e().func_234923_W_().getRegistryName());
    }

    static {
        dimensionMatcher = null;
        biomeMatcher = null;
    }
}

