/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.villages;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;

public class VillageStructures {
    private static void addPieceToPool(MutableRegistry<JigsawPattern> templatePoolRegistry, ResourceLocation poolRL, String nbtPieceRL, JigsawPattern.PlacementBehaviour projection, int weight) {
        JigsawPattern pool = (JigsawPattern)templatePoolRegistry.func_82594_a(poolRL);
        if (pool == null) {
            return;
        }
        SingleJigsawPiece piece = poolRL.func_110623_a().endsWith("streets") ? (SingleJigsawPiece)SingleJigsawPiece.func_242849_a((String)nbtPieceRL).apply(projection) : (SingleJigsawPiece)SingleJigsawPiece.func_242859_b((String)nbtPieceRL).apply(projection);
        for (int i = 0; i < weight; ++i) {
            pool.field_214953_e.add(piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.field_214952_d);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.field_214952_d = listOfPieceEntries;
    }

    public static void addMechanicHouse(FMLServerAboutToStartEvent event) {
        if (((Boolean)ConfigHelper.common().villagers.addMechanicHouse.get()).booleanValue()) {
            MutableRegistry templatePoolRegistry = event.getServer().func_244267_aX().func_243612_b(Registry.field_243555_ax);
            for (VillageBiome v : VillageBiome.values()) {
                if (v.needsCustomStreet()) {
                    VillageStructures.addPieceToPool((MutableRegistry<JigsawPattern>)templatePoolRegistry, new ResourceLocation("village/" + v.getBiomeName() + "/streets"), "pneumaticcraft:villages/custom_street_" + v.getBiomeName(), JigsawPattern.PlacementBehaviour.TERRAIN_MATCHING, 2);
                    continue;
                }
                VillageStructures.addPieceToPool((MutableRegistry<JigsawPattern>)templatePoolRegistry, new ResourceLocation("village/" + v.getBiomeName() + "/houses"), "pneumaticcraft:villages/mechanic_house_" + v.getBiomeName(), JigsawPattern.PlacementBehaviour.RIGID, 8);
            }
        }
    }

    static enum VillageBiome {
        PLAINS("plains", false),
        DESERT("desert", true),
        SAVANNA("savanna", false),
        TAIGA("taiga", false),
        SNOWY("snowy", true);

        private final String biomeName;
        private final boolean needsCustomStreet;

        private VillageBiome(String biomeName, boolean needsCustomStreet) {
            this.biomeName = biomeName;
            this.needsCustomStreet = needsCustomStreet;
        }

        public String getBiomeName() {
            return this.biomeName;
        }

        public boolean needsCustomStreet() {
            return this.needsCustomStreet;
        }
    }
}

