/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.ITagFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.math.NumberUtils;

public class PneumaticCraftUtils {
    private static final int MAX_CHAR_PER_LINE = 45;
    public static final double[] sin = new double[500];
    public static final double[] cos = new double[500];
    public static final int CIRCLE_POINTS = 500;

    public static Direction getDirectionFacing(LivingEntity entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return Direction.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return Direction.UP;
            }
        }
        if (yaw < 45.0) {
            return Direction.SOUTH;
        }
        if (yaw < 135.0) {
            return Direction.WEST;
        }
        if (yaw < 225.0) {
            return Direction.NORTH;
        }
        if (yaw < 315.0) {
            return Direction.EAST;
        }
        return Direction.SOUTH;
    }

    public static int getYawFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static List<ITextComponent> splitStringComponent(String text) {
        return PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(text, 45));
    }

    public static List<ITextComponent> splitStringComponent(String text, int maxCharPerLine) {
        return PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(text, maxCharPerLine));
    }

    public static List<String> splitString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("${br}"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                for (String word : Splitter.fixedLength((int)maxCharPerLine).split((CharSequence)token)) {
                    int idx = word.lastIndexOf("\u00a7");
                    if (idx >= 0 && idx < word.length() - 1) {
                        format = word.substring(idx, idx + 2);
                        lineLen -= 2;
                    }
                    if (lineLen + word.length() > maxCharPerLine) {
                        result.add(builder.toString());
                        builder.delete(0, builder.length());
                        builder.append(format);
                        lineLen = 0;
                    } else if (lineLen > 0) {
                        builder.append(" ");
                        ++lineLen;
                    }
                    builder.append(word);
                    lineLen += word.length();
                }
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static List<String> splitString(String text) {
        return PneumaticCraftUtils.splitString(text, 45);
    }

    public static List<ITextComponent> asStringComponent(List<String> l) {
        return l.stream().map(StringTextComponent::new).collect(Collectors.toList());
    }

    public static String convertTicksToMinutesAndSeconds(long ticks, boolean fraction) {
        String part = ticks % 20L * 5L + "";
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20L) < 60L) {
            return ticks + (fraction ? "." + part : "") + "s";
        }
        return ticks / 60L + "m " + ticks % 60L + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 10000) {
            return NumberFormat.getNumberInstance(Locale.getDefault()).format(amount);
        }
        if (amount < 1000000) {
            return amount / 1000 + "K";
        }
        return amount / 1000000 + "M";
    }

    public static String roundNumberTo(double value, int decimals) {
        return String.format("%." + decimals + "f", PneumaticCraftUtils.roundNumberToDouble(value, decimals));
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, RoundingMode.HALF_DOWN).doubleValue();
    }

    public static boolean epsilonEquals(float f1, float f2) {
        return PneumaticCraftUtils.epsilonEquals(f1, f2, 1.0E-4f);
    }

    public static boolean epsilonEquals(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    public static boolean epsilonEquals(double d1, double d2) {
        return PneumaticCraftUtils.epsilonEquals(d1, d2, 1.0E-4);
    }

    public static boolean epsilonEquals(double d1, double d2, double maxDifference) {
        return Math.abs(d1 - d2) < maxDifference;
    }

    public static void summariseItemStacks(List<ITextComponent> textList, ItemStack[] originalStacks) {
        PneumaticCraftUtils.summariseItemStacks(textList, originalStacks, Symbols.bullet().getString());
    }

    public static void summariseItemStacks(List<ITextComponent> textList, ItemStack[] originalStacks, String prefix) {
        ItemStack[] stacks = Arrays.copyOf(originalStacks, originalStacks.length);
        Arrays.sort(stacks, (o1, o2) -> o1.func_200301_q().getString().compareToIgnoreCase(o2.func_200301_q().getString()));
        int itemCount = 0;
        ItemStack prevItemStack = ItemStack.field_190927_a;
        List<ItemStack> prevInventoryItems = null;
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (!stack.func_77969_a(prevItemStack) || prevInventoryItems != null && prevInventoryItems.size() > 0) {
                if (!prevItemStack.func_190926_b()) {
                    PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_200301_q().getString());
                }
                if (prevInventoryItems != null) {
                    PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3" + " ");
                }
                prevItemStack = stack;
                itemCount = stack.func_190916_E();
            } else {
                itemCount += stack.func_190916_E();
            }
            prevInventoryItems = ItemRegistry.getInstance().getStacksInItem(stack);
        }
        if (itemCount > 0 && !prevItemStack.func_190926_b()) {
            PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_200301_q().getString());
            PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3" + " ");
        }
    }

    private static void addText(List<ITextComponent> l, String s) {
        l.add((ITextComponent)new StringTextComponent(s));
    }

    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        URL myUrl = new URL(urlString);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(myUrl.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.getProperty("line.separator"));
            }
        }
        return all.toString();
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vector3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vector3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetween(Vector3i pos1, Vector3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
    }

    public static boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkNBT, boolean checkModSimilarity) {
        if (filterStack.func_190926_b() && stack.func_190926_b()) {
            return true;
        }
        if (filterStack.func_190926_b() || stack.func_190926_b()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = filterStack.func_77973_b().getRegistryName().func_110624_b();
            String mod2 = stack.func_77973_b().getRegistryName().func_110624_b();
            return mod1.equals(mod2);
        }
        if (filterStack.func_77973_b() instanceof ITagFilteringItem) {
            return ((ITagFilteringItem)filterStack.func_77973_b()).matchTags(filterStack, stack.func_77973_b());
        }
        if (stack.func_77973_b() instanceof ITagFilteringItem) {
            return ((ITagFilteringItem)stack.func_77973_b()).matchTags(stack, filterStack.func_77973_b());
        }
        if (filterStack.func_77973_b() != stack.func_77973_b()) {
            return false;
        }
        boolean durabilityOK = !checkDurability || filterStack.func_77958_k() > 0 && filterStack.func_77952_i() == stack.func_77952_i();
        boolean nbtOK = !checkNBT || ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)stack);
        return durabilityOK && nbtOK;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof FlowingFluidBlock;
    }

    public static void dropItemOnGround(ItemStack stack, World world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, World world, double x, double y, double z) {
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, stack.func_77946_l());
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.func_213293_j(world.field_73012_v.nextGaussian() * (double)factor, world.field_73012_v.nextGaussian() * (double)factor + 0.2, world.field_73012_v.nextGaussian() * (double)factor);
        world.func_217376_c((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, World world, double x, double y, double z) {
        ItemEntity entityItem = new ItemEntity(world, x, y, z, stack.func_77946_l());
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        entityItem.func_213293_j(0.0, 0.0, 0.0);
        world.func_217376_c((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static PlayerEntity getPlayerFromId(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
    }

    public static PlayerEntity getPlayerFromName(String name) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(name);
    }

    public static boolean isPlayerOp(PlayerEntity player) {
        return player.func_211513_k(2);
    }

    public static boolean tryPlaceBlock(World w, BlockPos pos, PlayerEntity player, Direction face, BlockState newState) {
        BlockSnapshot snapshot = BlockSnapshot.create((RegistryKey)w.func_234923_W_(), (IWorld)w, (BlockPos)pos);
        if (!ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)snapshot, (Direction)face)) {
            w.func_175656_a(pos, newState);
            return true;
        }
        return false;
    }

    public static MobEntity createDummyEntity(PlayerEntity player) {
        ZombieEntity dummy = new ZombieEntity(player.field_70170_p){};
        dummy.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        return dummy;
    }

    public static boolean consumeInventoryItem(PlayerInventory inv, Item item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (((ItemStack)inv.field_70462_a.get(i)).func_77973_b() != item) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static void collectNonEmptyItems(IItemHandler handler, NonNullList<ItemStack> items) {
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                items.add((Object)handler.getStackInSlot(i));
            }
        }
    }

    public static boolean consumeInventoryItem(PlayerInventory inv, ItemStack stack) {
        int toConsume = stack.func_190916_E();
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            int consumed;
            ItemStack invStack = (ItemStack)inv.field_70462_a.get(i);
            if (ItemStack.func_179545_c((ItemStack)invStack, (ItemStack)stack)) {
                consumed = Math.min(invStack.func_190916_E(), stack.func_190916_E());
                invStack.func_190918_g(consumed);
            } else {
                consumed = invStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> {
                    for (int j = 0; j < h.getSlots(); ++j) {
                        ItemStack invStack2 = h.getStackInSlot(j);
                        if (!ItemStack.func_179545_c((ItemStack)invStack2, (ItemStack)stack)) continue;
                        int extracted = Math.min(invStack2.func_190916_E(), stack.func_190916_E());
                        ItemStack s = h.extractItem(j, extracted, false);
                        return s.func_190916_E();
                    }
                    return 0;
                }).orElse(0);
            }
            if ((toConsume -= consumed) > 0) continue;
            return true;
        }
        return toConsume <= 0;
    }

    public static TranslationTextComponent xlate(String s, Object ... args) {
        return new TranslationTextComponent(s, args);
    }

    public static ITextComponent dyeColorDesc(int c) {
        return new TranslationTextComponent("color.minecraft." + DyeColor.func_196056_a((int)c).func_176762_d()).func_240699_a_(TextFormatting.BOLD);
    }

    public static void copyItemHandler(IItemHandler source, ItemStackHandler dest, int maxSlots) {
        int nSlots = Math.min(maxSlots, source.getSlots());
        dest.setSize(nSlots);
        for (int i = 0; i < nSlots; ++i) {
            dest.setStackInSlot(i, source.getStackInSlot(i).func_77946_l());
        }
    }

    public static void copyItemHandler(IItemHandler source, ItemStackHandler dest) {
        PneumaticCraftUtils.copyItemHandler(source, dest, source.getSlots());
    }

    public static BlockPos getPosForEntity(Entity e) {
        return new BlockPos(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
    }

    public static String posToString(BlockPos pos) {
        return String.format("%d,%d,%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static <T extends TileEntity> Optional<T> getTileEntityAt(IBlockReader w, BlockPos pos, Class<T> cls) {
        TileEntity te;
        if (w != null && pos != null && (te = w.func_175625_s(pos)) != null && cls.isAssignableFrom(te.getClass())) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    public static boolean fillTankWithOrb(IFluidHandler handler, ExperienceOrbEntity orb, IFluidHandler.FluidAction action) {
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        int fluidAmount = orb.func_70526_d() * ratio;
        FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
        int filled = handler.fill(toFill, action);
        if (filled > 0 && filled < fluidAmount && action.execute()) {
            orb.field_70530_e -= Math.max(1, filled / ratio);
        }
        return filled == fluidAmount;
    }

    public static double getPlayerReachDistance(PlayerEntity player) {
        ModifiableAttributeInstance attr;
        if (player != null && (attr = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            return attr.func_111126_e() + 1.0;
        }
        return 4.5;
    }

    public static boolean canPlayerReach(PlayerEntity player, BlockPos pos) {
        if (player == null) {
            return false;
        }
        double dist = PneumaticCraftUtils.getPlayerReachDistance(player);
        return player.func_195048_a(Vector3d.func_237489_a_((Vector3i)pos)) <= dist * dist;
    }

    public static int getMinHeight(World world) {
        return 0;
    }

    public static boolean isInteger(String str) {
        if (str.isEmpty() || str.equals("-")) {
            return true;
        }
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        return NumberUtils.isDigits((String)str);
    }

    public static boolean isNumber(String str) {
        if (str.isEmpty() || str.equals("-")) {
            return true;
        }
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        if (str.endsWith(".")) {
            str = str + "0";
        }
        return NumberUtils.isParsable((String)str);
    }

    public static ResourceLocation modDefaultedRL(String str) {
        return str.indexOf(58) > 0 ? new ResourceLocation(str) : new ResourceLocation("pneumaticcraft", str);
    }

    public static String modDefaultedString(ResourceLocation rl) {
        return rl.func_110624_b().equals("pneumaticcraft") ? rl.func_110623_a() : rl.toString();
    }

    public static synchronized CompoundNBT copyNBTWithout(@Nonnull CompoundNBT nbt, @Nonnull String skip) {
        CompoundNBT newNBT = new CompoundNBT();
        for (String key : nbt.func_150296_c()) {
            INBT subTag;
            if (skip.equals(key) || (subTag = nbt.func_74781_a(key)) == null) continue;
            newNBT.func_218657_a(key, subTag.func_74737_b());
        }
        return newNBT.isEmpty() ? new CompoundNBT() : newNBT;
    }

    static {
        for (int i = 0; i < 500; ++i) {
            double angle = Math.PI * 2 * (double)i / 500.0;
            PneumaticCraftUtils.sin[i] = Math.sin(angle);
            PneumaticCraftUtils.cos[i] = Math.cos(angle);
        }
    }
}

