/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.amadron.BiomeMatcher;
import me.desht.pneumaticcraft.common.amadron.DimensionMatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.Validate;

public class PlayerFilter
implements Predicate<PlayerEntity> {
    public static final PlayerFilter YES = new PlayerFilter(Op.YES, Collections.emptyMap());
    public static final PlayerFilter NO = new PlayerFilter(Op.NO, Collections.emptyMap());
    private static final Map<ResourceLocation, IPlayerMatcher.MatcherFactory<?>> matcherFactories = new ConcurrentHashMap();
    private final Map<ResourceLocation, IPlayerMatcher> matchers;
    private final Op op;

    private PlayerFilter(Op op, @Nonnull Map<ResourceLocation, IPlayerMatcher> matchers) {
        Validate.isTrue((op.isFake() || !matchers.isEmpty() ? 1 : 0) != 0, (String)"received empty matcher list!", (Object[])new Object[0]);
        this.op = op;
        this.matchers = ImmutableMap.copyOf(matchers);
    }

    public static PlayerFilter fromJson(JsonObject json) {
        for (String opStr : new String[]{"or", "and"}) {
            HashMap<ResourceLocation, IPlayerMatcher> matchers = new HashMap<ResourceLocation, IPlayerMatcher>();
            if (!json.has(opStr)) continue;
            Op op = Op.valueOf(opStr.toUpperCase(Locale.ROOT));
            JsonObject jsonSub = json.getAsJsonObject(opStr);
            for (Map.Entry entry : jsonSub.entrySet()) {
                ResourceLocation id = PlayerFilter.getId((String)entry.getKey());
                if (matcherFactories.containsKey(id)) {
                    matchers.put(id, (IPlayerMatcher)matcherFactories.get(id).fromJson((JsonElement)entry.getValue()));
                    continue;
                }
                throw new JsonSyntaxException("unknown matcher: " + id);
            }
            return new PlayerFilter(op, matchers);
        }
        throw new JsonSyntaxException("must provide one of 'and' or 'or'!");
    }

    public static PlayerFilter fromBytes(PacketBuffer buffer) {
        Op op = (Op)buffer.func_179257_a(Op.class);
        int nMatchers = buffer.func_150792_a();
        HashMap<ResourceLocation, IPlayerMatcher> map = new HashMap<ResourceLocation, IPlayerMatcher>();
        for (int i = 0; i < nMatchers; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            map.put(id, (IPlayerMatcher)matcherFactories.get(id).fromBytes(buffer));
        }
        return new PlayerFilter(op, map);
    }

    public static void registerDefaultMatchers() {
        PlayerFilter.registerMatcher("dimensions", new DimensionMatcher.Factory());
        PlayerFilter.registerMatcher("biome_categories", new BiomeMatcher.Factory());
    }

    public static void registerMatcher(String id, IPlayerMatcher.MatcherFactory<?> matcher) {
        matcherFactories.put(PlayerFilter.getId(id), matcher);
    }

    public boolean isReal() {
        return !this.op.isFake();
    }

    public boolean matchAll() {
        return this.op == Op.AND;
    }

    private static ResourceLocation getId(String key) {
        return key.contains(":") ? new ResourceLocation(key) : PneumaticRegistry.RL(key);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.op);
        buffer.func_150787_b(this.matchers.size());
        this.matchers.forEach((id, matcher) -> {
            buffer.func_192572_a(id);
            matcher.toBytes(buffer);
        });
    }

    public JsonObject toJson() {
        JsonObject sub = new JsonObject();
        this.matchers.forEach((id, matcher) -> sub.add(id.toString(), matcher.toJson()));
        JsonObject res = new JsonObject();
        res.add(this.op.name(), (JsonElement)sub);
        return res;
    }

    @Override
    public boolean test(PlayerEntity player) {
        switch (this.op) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case OR: {
                return this.matchers.values().stream().anyMatch(matcher -> matcher.test(player));
            }
            case AND: {
                return this.matchers.values().stream().allMatch(matcher -> matcher.test(player));
            }
        }
        return false;
    }

    public void getDescription(PlayerEntity player, List<ITextComponent> tooltip) {
        if (this.isReal()) {
            this.matchers.values().forEach(matcher -> matcher.addDescription(player, tooltip));
        }
    }

    public String toString() {
        String delimiter = " " + this.op.toString() + " ";
        return "[" + this.matchers.values().stream().map(Object::toString).collect(Collectors.joining(delimiter)) + "]";
    }

    private static enum Op {
        YES,
        NO,
        AND,
        OR;


        public boolean isFake() {
            return this == YES || this == NO;
        }
    }
}

