/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerSentryTurret;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySentryTurret
extends TileEntityTickableBase
implements IRedstoneControl<TileEntitySentryTurret>,
IGUITextFieldSensitive,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 4;
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    private final ItemStackHandler inventory = new TurretItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    private String entityFilter = "@mob";
    @GuiSynced
    private final RedstoneController<TileEntitySentryTurret> rsController = new RedstoneController<TileEntitySentryTurret>(this);
    @DescSynced
    private double range;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack = ItemStack.field_190927_a;
    private Minigun minigun;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();
    private double rangeSq;
    private Vector3d tileVec;
    @DescSynced
    private float idleYaw;

    public TileEntitySentryTurret() {
        super((TileEntityType)ModTileEntities.SENTRY_TURRET.get(), 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            LivingEntity target;
            if (this.getMinigun().getAttackTarget() == null && this.rsController.shouldRun()) {
                this.getMinigun().setSweeping(true);
                if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                    List entities = this.func_145831_w().func_175647_a(LivingEntity.class, this.getTargetingBoundingBox(), (Predicate)((Object)this.entitySelector));
                    if (entities.size() > 0) {
                        entities.sort(new EntityDistanceComparator(this.func_174877_v()));
                        this.getMinigun().setAttackTarget((LivingEntity)entities.get(0));
                        this.targetEntityId = ((LivingEntity)entities.get(0)).func_145782_y();
                    } else if (this.targetEntityId > 0) {
                        this.getMinigun().setReturning(true);
                        this.targetEntityId = -1;
                    }
                }
            } else {
                this.getMinigun().setSweeping(false);
            }
            if ((target = this.getMinigun().getAttackTarget()) != null) {
                if (this.rsController.shouldRun() && this.entitySelector.test((Entity)target)) {
                    if ((this.func_145831_w().func_82737_E() & 7L) == 0L) {
                        this.getFakePlayer().func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                        boolean usedUpAmmo = this.getMinigun().tryFireMinigun((Entity)target);
                        if (usedUpAmmo) {
                            this.clearEmptyAmmo();
                        }
                    }
                } else {
                    this.getMinigun().setAttackTarget(null);
                    this.getMinigun().minigunYaw = this.idleYaw;
                    this.targetEntityId = -1;
                }
            }
        }
        this.getMinigun().update((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
    }

    private void clearEmptyAmmo() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemGunAmmo) || stack.func_77952_i() < stack.func_77958_k()) continue;
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        blockEntityTag.func_74778_a(NBT_ENTITY_FILTER, this.getText(0));
    }

    private boolean canTurretSeeEntity(Entity entity) {
        Vector3d entityVec = new Vector3d(entity.func_226277_ct_() + (double)(entity.func_213311_cf() / 2.0f), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_() + (double)(entity.func_213311_cf() / 2.0f));
        RayTraceContext ctx = new RayTraceContext(entityVec, this.tileVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        BlockRayTraceResult trace = this.func_145831_w().func_217299_a(ctx);
        return trace.func_216350_a().equals((Object)this.func_174877_v());
    }

    private AxisAlignedBB getTargetingBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v()).func_186662_g(this.range);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(1.0);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.tileVec = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        this.updateAmmo();
        this.onFilterChanged(this.entityFilter);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.func_145831_w().func_73045_a(this.targetEntityId);
        if (entity instanceof LivingEntity) {
            this.getMinigun().setAttackTarget((LivingEntity)entity);
        } else {
            this.getMinigun().setAttackTarget(null);
            this.getMinigun().setReturning(true);
        }
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret(this.field_145850_b.field_72995_K ? null : this.getFakePlayer());
            this.minigun.setWorld(this.func_145831_w());
            this.minigun.minigunYaw = this.idleYaw;
            this.minigun.setIdleYaw(this.idleYaw);
        }
        return this.minigun;
    }

    private PlayerEntity getFakePlayer() {
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.func_145831_w()), (GameProfile)new GameProfile(null, "Sentry Turret"));
        if (fakePlayer.field_71135_a == null) {
            fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        tag.func_74778_a(NBT_ENTITY_FILTER, this.entityFilter);
        tag.func_74776_a("idleYaw", this.idleYaw);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.idleYaw = tag.func_74760_g("idleYaw");
        this.setText(0, tag.func_74779_i(NBT_ENTITY_FILTER));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public RedstoneController<TileEntitySentryTurret> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSentryTurret(i, playerInventory, this.func_174877_v());
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = Minigun.clampYaw(idleYaw);
    }

    private void updateAmmo() {
        ItemStack ammo = ItemStack.field_190927_a;
        for (int i = 0; i < this.inventory.getSlots() && (ammo = this.inventory.getStackInSlot(i)).func_190926_b(); ++i) {
        }
        this.getMinigun().setAmmoStack(ammo);
        this.recalculateRange();
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null) {
            this.recalculateRange();
        }
    }

    private void recalculateRange() {
        this.range = 16 + Math.min(16, this.getUpgrades(EnumUpgrade.RANGE));
        ItemStack ammoStack = this.getMinigun().getAmmoStack();
        if (ammoStack.func_77973_b() instanceof ItemGunAmmo) {
            this.range *= (double)((ItemGunAmmo)ammoStack.func_77973_b()).getRangeMultiplier(ammoStack);
        }
        this.rangeSq = this.range * this.range;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.onFilterChanged(text);
            if (this.minigun != null) {
                this.minigun.setAttackTarget(null);
            }
        }
    }

    private void onFilterChanged(String text) {
        this.entitySelector.setFilter(text);
        this.func_70296_d();
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        public boolean test(Entity entity) {
            PlayerEntity player;
            if (entity instanceof PlayerEntity && ((player = (PlayerEntity)entity).func_184812_l_() || player.func_175149_v() || this.isExcludedBySecurityStations(player))) {
                return false;
            }
            return super.test((Object)entity) && this.inRange(entity) && TileEntitySentryTurret.this.canTurretSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetweenSq((Vector3i)new BlockPos(TileEntitySentryTurret.this.func_174877_v().func_177958_n(), TileEntitySentryTurret.this.func_174877_v().func_177956_o(), TileEntitySentryTurret.this.func_174877_v().func_177952_p()), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()) <= TileEntitySentryTurret.this.rangeSq;
        }

        private boolean isExcludedBySecurityStations(PlayerEntity player) {
            Iterator iterator = TileEntitySecurityStation.getSecurityStations(TileEntitySentryTurret.this.func_145831_w(), TileEntitySentryTurret.this.func_174877_v(), false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (((TileEntitySecurityStation)iterator.next()).doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        MinigunSentryTurret(PlayerEntity fakePlayer) {
            super(fakePlayer, true);
        }

        @Override
        public boolean isMinigunActivated() {
            return TileEntitySentryTurret.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            if (!this.world.field_72995_K) {
                TileEntitySentryTurret.this.activated = activated;
            }
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!this.world.field_72995_K) {
                TileEntitySentryTurret.this.minigunColorStack = ammo;
            }
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(TileEntitySentryTurret.this.minigunColorStack);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            this.world.func_184133_a(null, TileEntitySentryTurret.this.func_174877_v(), soundName, SoundCategory.BLOCKS, volume, pitch);
        }

        @Override
        @Nullable
        public Vector3d getMuzzlePosition() {
            Vector3d centre = Vector3d.func_237489_a_((Vector3i)TileEntitySentryTurret.this.getPosition());
            LivingEntity target = TileEntitySentryTurret.this.minigun.getAttackTarget();
            if (target == null) {
                return null;
            }
            Vector3d offset = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() / 2.0f), 0.0).func_178788_d(centre).func_72441_c(0.0, 0.5, 0.0).func_72432_b().func_186678_a(1.5);
            return centre.func_178787_e(offset);
        }

        @Override
        public Vector3d getLookAngle() {
            return Vector3d.func_189986_a((float)this.minigunPitch, (float)this.minigunYaw).func_72432_b();
        }

        @Override
        public float getParticleScale() {
            return 1.0f;
        }

        @Override
        public void setSweeping(boolean sweeping) {
            TileEntitySentryTurret.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return TileEntitySentryTurret.this.sweeping;
        }

        @Override
        public PacketPlayMovingSound.SoundSource getSoundSource() {
            return PacketPlayMovingSound.SoundSource.of(TileEntitySentryTurret.this);
        }

        @Override
        public boolean isValid() {
            return !TileEntitySentryTurret.this.func_145837_r();
        }
    }

    private class TurretItemStackHandler
    extends BaseItemStackHandler {
        TurretItemStackHandler(TileEntity te) {
            super(te, 4);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySentryTurret.this.updateAmmo();
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }
    }
}

