/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.BlockOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityOmnidirectionalHopper
extends TileEntityAbstractHopper<TileEntityOmnidirectionalHopper> {
    public static final int INVENTORY_SIZE = 5;
    private final ComparatorItemStackHandler itemHandler = new ComparatorItemStackHandler(this, this.getInvSize());
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.itemHandler);
    @GuiSynced
    public boolean roundRobin;
    private int rrSlot;
    @GuiSynced
    private final RedstoneController<TileEntityOmnidirectionalHopper> rsController = new RedstoneController<TileEntityOmnidirectionalHopper>(this);

    public TileEntityOmnidirectionalHopper() {
        super((TileEntityType)ModTileEntities.OMNIDIRECTIONAL_HOPPER.get());
    }

    protected int getInvSize() {
        return 5;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    protected int getComparatorValueInternal() {
        return this.itemHandler.getComparatorValue();
    }

    @Override
    protected boolean doExport(int maxItems) {
        Direction outputDir = this.getRotation();
        LazyOptional<IItemHandler> inv = IOHelper.getInventoryForTE(this.getCachedNeighbor(outputDir), outputDir.func_176734_d());
        int notExported = maxItems;
        if (inv.isPresent()) {
            notExported = inv.map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems);
        } else if (this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0) {
            notExported = this.tryEntityExport(maxItems, outputDir.func_176734_d());
        }
        if (notExported == maxItems && ((Boolean)ConfigHelper.common().machines.omniHopperDispenser.get()).booleanValue() && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            notExported = this.exportToInventory(new DropInWorldHandler(this.func_145831_w(), this.func_174877_v(), outputDir), maxItems);
        }
        return notExported < maxItems;
    }

    private int tryEntityExport(int maxItems, Direction dir) {
        for (Entity e : this.cachedOutputEntities) {
            int notExported;
            if (!e.func_70089_S() || (notExported = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems).intValue()) >= maxItems) continue;
            return notExported;
        }
        return maxItems;
    }

    private int exportToInventory(IItemHandler otherHandler, int maxItems) {
        int remaining = maxItems;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(this.actualSlot(i));
            if (stack.func_190916_E() <= this.leaveMaterialCount) continue;
            ItemStack exportedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(stack.func_190916_E() - this.leaveMaterialCount, remaining));
            int toExport = exportedStack.func_190916_E();
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)exportedStack, (boolean)false);
            int exportedCount = toExport - excess.func_190916_E();
            if (!this.isCreative) {
                stack.func_190918_g(exportedCount);
                if (exportedCount > 0) {
                    this.itemHandler.invalidateComparatorValue();
                }
            }
            if ((remaining -= exportedCount) > this.leaveMaterialCount) continue;
            if (!this.roundRobin) break;
            this.rrSlot = this.actualSlot(i) + 1;
            if (this.rrSlot < this.itemHandler.getSlots()) break;
            this.rrSlot = 0;
            break;
        }
        return remaining;
    }

    private int actualSlot(int i) {
        if (this.roundRobin) {
            int slot = this.rrSlot + i;
            if (slot >= this.itemHandler.getSlots()) {
                slot -= this.itemHandler.getSlots();
            }
            return slot;
        }
        return i;
    }

    @Override
    protected boolean doImport(int maxItems) {
        boolean success = false;
        if (this.isInventoryFull()) {
            return false;
        }
        LazyOptional<IItemHandler> cap = IOHelper.getInventoryForTE(this.getCachedNeighbor(this.inputDir), this.inputDir.func_176734_d());
        if (cap.isPresent()) {
            int imported = cap.map(otherHandler -> this.importFromInventory((IItemHandler)otherHandler, maxItems, false)).orElse(0);
            return imported > 0;
        }
        if (this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0 && this.tryEntityImport(maxItems) > 0) {
            return true;
        }
        BlockPos inputPos = this.field_174879_c.func_177972_a(this.inputDir);
        if (!Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)inputPos, (Direction)this.inputDir.func_176734_d())) {
            for (Entity e : this.cachedInputEntities) {
                if (!e.func_70089_S() || !(e instanceof ItemEntity)) continue;
                ItemEntity entity = (ItemEntity)e;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)entity.func_92059_d(), (boolean)false);
                if (remainder.func_190926_b()) {
                    entity.func_70106_y();
                    success = true;
                    continue;
                }
                if (remainder.func_190916_E() >= entity.func_92059_d().func_190916_E()) continue;
                entity.func_92058_a(remainder);
                success = true;
            }
        }
        return success;
    }

    private int tryEntityImport(int maxItems) {
        Direction dir = this.inputDir.func_176734_d();
        int remaining = maxItems;
        for (Entity e : this.cachedInputEntities) {
            boolean playerArmor;
            if (!this.validForExtraction(e)) continue;
            int r = remaining;
            boolean bl = playerArmor = e instanceof PlayerEntity && dir.func_176740_k().func_176722_c();
            int imported = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).map(h -> this.importFromInventory((IItemHandler)h, r, playerArmor)).orElse(0);
            if ((remaining -= imported) > 0) continue;
            return maxItems - remaining;
        }
        return 0;
    }

    private boolean validForExtraction(Entity e) {
        return e.func_70089_S() && !e.func_200600_R().func_220341_a(PneumaticCraftTags.EntityTypes.OMNIHOPPER_BLACKLISTED);
    }

    private int importFromInventory(IItemHandler inv, int maxItems, boolean playerArmor) {
        int remaining = maxItems;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            ItemStack toExtract = inv.extractItem(i, remaining, true);
            if (playerArmor && EnchantmentHelper.func_190938_b((ItemStack)toExtract)) continue;
            ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)toExtract, (boolean)false);
            int transferred = toExtract.func_190916_E() - excess.func_190916_E();
            if (transferred <= 0) continue;
            inv.extractItem(i, transferred, false);
            if ((remaining -= transferred) > 0) continue;
            return maxItems;
        }
        return maxItems - remaining;
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void setupInputOutputRegions() {
        AxisAlignedBB bowl = BlockOmnidirectionalHopper.INPUT_SHAPES[this.inputDir.func_176745_a()].func_197752_a().func_186670_a(this.field_174879_c);
        this.inputAABB = bowl.func_111270_a(new AxisAlignedBB(this.field_174879_c.func_177972_a(this.inputDir)));
        this.outputAABB = new AxisAlignedBB(this.func_174877_v().func_177972_a(this.getRotation()));
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        if (Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir), (Direction)dir.func_176734_d()) || dir == this.getRotation() && this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) == 0) {
            return false;
        }
        TileEntity te = this.getCachedNeighbor(dir);
        return te == null || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).isPresent();
    }

    @Override
    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_74757_a("RoundRobin", this.roundRobin);
        if (this.roundRobin) {
            tag.func_74768_a("RRSlot", this.rrSlot);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.roundRobin = tag.func_74767_n("RoundRobin");
        this.rrSlot = tag.func_74762_e("RRSlot");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerOmnidirectionalHopper(i, playerInventory, this.func_174877_v());
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (tag.equals("rr")) {
            this.roundRobin = !this.roundRobin;
            this.func_70296_d();
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public RedstoneController<TileEntityOmnidirectionalHopper> getRedstoneController() {
        return this.rsController;
    }

    private static class DropInWorldHandler
    implements IItemHandler {
        private final World world;
        private final BlockPos pos;
        private final Direction outputDir;

        public DropInWorldHandler(World world, BlockPos pos, Direction outputDir) {
            this.world = world;
            this.pos = pos.func_177972_a(outputDir);
            this.outputDir = outputDir;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Block.func_220055_a((IWorldReader)this.world, (BlockPos)this.pos, (Direction)this.outputDir.func_176734_d())) {
                if (!simulate) {
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.world, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
                }
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

